/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.channel.WriteCoalescer;
import com.datastax.oss.driver.shaded.netty.channel.Channel;
import com.datastax.oss.driver.shaded.netty.channel.ChannelFuture;
import com.datastax.oss.driver.shaded.netty.channel.ChannelPromise;
import com.datastax.oss.driver.shaded.netty.channel.EventLoop;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultWriteCoalescer
implements WriteCoalescer {
    private final long rescheduleIntervalNanos;
    private final ConcurrentMap<EventLoop, Flusher> flushers = new ConcurrentHashMap<EventLoop, Flusher>();

    public DefaultWriteCoalescer(DriverContext context) {
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        this.rescheduleIntervalNanos = config.getDuration(DefaultDriverOption.COALESCER_INTERVAL).toNanos();
    }

    @Override
    public ChannelFuture writeAndFlush(Channel channel, Object message) {
        ChannelPromise writePromise = channel.newPromise();
        Write write = new Write(channel, message, writePromise);
        this.enqueue(write, channel.eventLoop());
        return writePromise;
    }

    private void enqueue(Write write, EventLoop eventLoop) {
        Flusher flusher = this.flushers.computeIfAbsent(eventLoop, x$0 -> new Flusher((EventLoop)x$0));
        flusher.enqueue(write);
    }

    private static class Write {
        private final Channel channel;
        private final Object message;
        private final ChannelPromise writePromise;

        private Write(Channel channel, Object message, ChannelPromise writePromise) {
            this.channel = channel;
            this.message = message;
            this.writePromise = writePromise;
        }
    }

    private class Flusher {
        private final EventLoop eventLoop;
        private final Queue<Write> writes = new ConcurrentLinkedQueue<Write>();
        private final AtomicBoolean running = new AtomicBoolean();
        private final Set<Channel> channels = new HashSet<Channel>();

        private Flusher(EventLoop eventLoop) {
            this.eventLoop = eventLoop;
        }

        private void enqueue(Write write) {
            boolean added = this.writes.offer(write);
            assert (added);
            if (this.running.compareAndSet(false, true)) {
                this.eventLoop.execute(this::runOnEventLoop);
            }
        }

        private void runOnEventLoop() {
            Write write;
            assert (this.eventLoop.inEventLoop());
            while ((write = this.writes.poll()) != null) {
                Channel channel = write.channel;
                this.channels.add(channel);
                channel.write(write.message, write.writePromise);
            }
            for (Channel channel : this.channels) {
                channel.flush();
            }
            this.channels.clear();
            this.running.set(false);
            if (this.writes.isEmpty()) {
                return;
            }
            boolean shouldRestartMyself = this.running.compareAndSet(false, true);
            if (shouldRestartMyself && !this.eventLoop.isShuttingDown()) {
                this.eventLoop.schedule(this::runOnEventLoop, DefaultWriteCoalescer.this.rescheduleIntervalNanos, TimeUnit.NANOSECONDS);
            }
        }
    }
}

