/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.visibility;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tephra.TransactionContext;
import org.apache.tephra.TransactionFailureException;
import org.apache.tephra.shaded.com.google.common.base.Stopwatch;
import org.apache.tephra.visibility.FenceWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFenceWait
implements FenceWait {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFenceWait.class);
    private final TransactionContext txContext;

    DefaultFenceWait(TransactionContext txContext) {
        this.txContext = txContext;
    }

    @Override
    public void await(long timeout, TimeUnit timeUnit) throws TransactionFailureException, InterruptedException, TimeoutException {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        long sleepTimeMicros = timeUnit.toMicros(timeout) / 10L;
        sleepTimeMicros = Math.max(Math.min(sleepTimeMicros, 500000L), 1L);
        while (stopwatch.elapsedTime(timeUnit) < timeout) {
            this.txContext.start();
            try {
                this.txContext.finish();
                return;
            }
            catch (TransactionFailureException e) {
                LOG.error("Got exception waiting for fence. Sleeping for {} microseconds", (Object)sleepTimeMicros, (Object)e);
                this.txContext.abort();
                TimeUnit.MICROSECONDS.sleep(sleepTimeMicros);
            }
        }
        throw new TimeoutException("Timeout waiting for fence");
    }
}

