/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.internal.kafka.client;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.tephra.shaded.com.google.common.base.Objects;
import org.apache.tephra.shaded.com.google.common.collect.Lists;
import org.apache.tephra.shaded.com.google.common.util.concurrent.Futures;
import org.apache.tephra.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.tephra.shaded.org.apache.twill.common.Cancellable;
import org.apache.tephra.shaded.org.apache.twill.common.Threads;
import org.apache.tephra.shaded.org.apache.twill.internal.kafka.client.ByteBufferEncoder;
import org.apache.tephra.shaded.org.apache.twill.internal.kafka.client.IntegerEncoder;
import org.apache.tephra.shaded.org.apache.twill.internal.kafka.client.IntegerPartitioner;
import org.apache.tephra.shaded.org.apache.twill.kafka.client.BrokerService;
import org.apache.tephra.shaded.org.apache.twill.kafka.client.Compression;
import org.apache.tephra.shaded.org.apache.twill.kafka.client.KafkaPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleKafkaPublisher
implements KafkaPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleKafkaPublisher.class);
    private final BrokerService brokerService;
    private final KafkaPublisher.Ack ack;
    private final Compression compression;
    private final AtomicReference<Producer<Integer, ByteBuffer>> producer;
    private final AtomicBoolean listenerCancelled;

    public SimpleKafkaPublisher(BrokerService brokerService, KafkaPublisher.Ack ack, Compression compression) {
        this.brokerService = brokerService;
        this.ack = ack;
        this.compression = compression;
        this.producer = new AtomicReference();
        this.listenerCancelled = new AtomicBoolean(false);
    }

    Cancellable start() {
        ExecutorService listenerExecutor = Executors.newSingleThreadExecutor(Threads.createDaemonThreadFactory("kafka-publisher"));
        final BrokerListChangeListener listener = new BrokerListChangeListener(this.listenerCancelled, this.producer, this.ack, this.compression);
        Cancellable cancelChangeListener = this.brokerService.addChangeListener(listener, listenerExecutor);
        Future<?> completion = listenerExecutor.submit(new Runnable(){

            @Override
            public void run() {
                listener.changed(SimpleKafkaPublisher.this.brokerService);
            }
        });
        Futures.getUnchecked(completion);
        return new ProducerCancellable(listenerExecutor, this.listenerCancelled, cancelChangeListener, this.producer);
    }

    @Override
    public KafkaPublisher.Preparer prepare(String topic) {
        return new SimplePreparer(topic);
    }

    private static final class ProducerCancellable
    implements Cancellable,
    Runnable {
        private final ExecutorService executor;
        private final AtomicBoolean listenerCancelled;
        private final Cancellable cancelChangeListener;
        private final AtomicReference<Producer<Integer, ByteBuffer>> producer;

        private ProducerCancellable(ExecutorService executor, AtomicBoolean listenerCancelled, Cancellable cancelChangeListener, AtomicReference<Producer<Integer, ByteBuffer>> producer) {
            this.executor = executor;
            this.listenerCancelled = listenerCancelled;
            this.cancelChangeListener = cancelChangeListener;
            this.producer = producer;
        }

        @Override
        public void cancel() {
            if (this.listenerCancelled.compareAndSet(false, true)) {
                this.executor.execute(this);
            }
        }

        @Override
        public void run() {
            this.cancelChangeListener.cancel();
            Producer<Integer, ByteBuffer> kafkaProducer = this.producer.get();
            kafkaProducer.close();
            this.executor.shutdownNow();
        }
    }

    private static final class BrokerListChangeListener
    extends BrokerService.BrokerChangeListener {
        private final AtomicBoolean listenerCancelled;
        private final AtomicReference<Producer<Integer, ByteBuffer>> producer;
        private final KafkaPublisher.Ack ack;
        private final Compression compression;
        private String brokerList;

        private BrokerListChangeListener(AtomicBoolean listenerCancelled, AtomicReference<Producer<Integer, ByteBuffer>> producer, KafkaPublisher.Ack ack, Compression compression) {
            this.listenerCancelled = listenerCancelled;
            this.producer = producer;
            this.ack = ack;
            this.compression = compression;
        }

        @Override
        public void changed(BrokerService brokerService) {
            if (this.listenerCancelled.get()) {
                return;
            }
            String newBrokerList = brokerService.getBrokerList();
            if (newBrokerList.isEmpty()) {
                LOG.warn("Broker list is empty. No Kafka producer is created.");
                return;
            }
            if (Objects.equal(this.brokerList, newBrokerList)) {
                return;
            }
            Properties props = new Properties();
            props.put("metadata.broker.list", newBrokerList);
            props.put("serializer.class", ByteBufferEncoder.class.getName());
            props.put("key.serializer.class", IntegerEncoder.class.getName());
            props.put("partitioner.class", IntegerPartitioner.class.getName());
            props.put("request.required.acks", Integer.toString(this.ack.getAck()));
            props.put("compression.codec", this.compression.getCodec());
            ProducerConfig config = new ProducerConfig(props);
            Producer<Integer, ByteBuffer> oldProducer = this.producer.getAndSet((Producer<Integer, ByteBuffer>)new Producer(config));
            if (oldProducer != null) {
                oldProducer.close();
            }
            LOG.info("Update Kafka producer broker list: {}", (Object)newBrokerList);
            this.brokerList = newBrokerList;
        }
    }

    private final class SimplePreparer
    implements KafkaPublisher.Preparer {
        private final String topic;
        private final List<KeyedMessage<Integer, ByteBuffer>> messages;

        private SimplePreparer(String topic) {
            this.topic = topic;
            this.messages = Lists.newLinkedList();
        }

        @Override
        public KafkaPublisher.Preparer add(ByteBuffer message, Object partitionKey) {
            this.messages.add((KeyedMessage<Integer, ByteBuffer>)new KeyedMessage(this.topic, (Object)Math.abs(partitionKey.hashCode()), (Object)message));
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListenableFuture<Integer> send() {
            try {
                int size = this.messages.size();
                Producer kafkaProducer = (Producer)SimpleKafkaPublisher.this.producer.get();
                if (kafkaProducer == null) {
                    ListenableFuture<Integer> listenableFuture = Futures.immediateFailedFuture(new IllegalStateException("No kafka producer available."));
                    return listenableFuture;
                }
                kafkaProducer.send(this.messages);
                ListenableFuture<Integer> listenableFuture = Futures.immediateFuture(size);
                return listenableFuture;
            }
            catch (Exception e) {
                ListenableFuture<Integer> listenableFuture = Futures.immediateFailedFuture(e);
                return listenableFuture;
            }
            finally {
                this.messages.clear();
            }
        }
    }
}

