/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.internal.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.apache.tephra.shaded.org.apache.twill.api.logging.LogEntry;
import org.apache.tephra.shaded.org.apache.twill.api.logging.LogThrowable;
import org.apache.tephra.shaded.org.apache.twill.internal.json.JsonUtils;

public final class LogEntryDecoder
implements JsonDeserializer<LogEntry> {
    private static final StackTraceElement[] EMPTY_STACK_TRACES = new StackTraceElement[0];

    public LogEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return null;
        }
        JsonObject jsonObj = json.getAsJsonObject();
        final String name = JsonUtils.getAsString(jsonObj, "name");
        final String host = JsonUtils.getAsString(jsonObj, "host");
        final long timestamp = JsonUtils.getAsLong(jsonObj, "timestamp", 0L);
        final LogEntry.Level logLevel = LogEntry.Level.valueOf(JsonUtils.getAsString(jsonObj, "level"));
        final String className = JsonUtils.getAsString(jsonObj, "className");
        final String method = JsonUtils.getAsString(jsonObj, "method");
        final String file = JsonUtils.getAsString(jsonObj, "file");
        final String line = JsonUtils.getAsString(jsonObj, "line");
        final String thread = JsonUtils.getAsString(jsonObj, "thread");
        final String message = JsonUtils.getAsString(jsonObj, "message");
        final String runnableName = JsonUtils.getAsString(jsonObj, "runnableName");
        final LogThrowable logThrowable = (LogThrowable)context.deserialize(jsonObj.get("throwable"), LogThrowable.class);
        return new LogEntry(){

            @Override
            public String getLoggerName() {
                return name;
            }

            @Override
            public String getHost() {
                return host;
            }

            @Override
            public long getTimestamp() {
                return timestamp;
            }

            @Override
            public LogEntry.Level getLogLevel() {
                return logLevel;
            }

            @Override
            public String getSourceClassName() {
                return className;
            }

            @Override
            public String getSourceMethodName() {
                return method;
            }

            @Override
            public String getFileName() {
                return file;
            }

            @Override
            public int getLineNumber() {
                if (line.equals("?")) {
                    return -1;
                }
                return Integer.parseInt(line);
            }

            @Override
            public String getThreadName() {
                return thread;
            }

            @Override
            public String getMessage() {
                return message;
            }

            @Override
            public String getRunnableName() {
                return runnableName;
            }

            @Override
            public LogThrowable getThrowable() {
                return logThrowable;
            }

            @Override
            public StackTraceElement[] getStackTraces() {
                LogThrowable throwable = this.getThrowable();
                return throwable == null ? EMPTY_STACK_TRACES : throwable.getStackTraces();
            }
        };
    }
}

