/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.api.logging;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.tephra.shaded.org.apache.twill.api.logging.LogEntry;
import org.apache.tephra.shaded.org.apache.twill.api.logging.LogHandler;
import org.apache.tephra.shaded.org.apache.twill.api.logging.LogThrowable;

public final class PrinterLogHandler
implements LogHandler {
    private static final Pattern DOT_SPLIT = Pattern.compile("\\.");
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss,SSS'Z'");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format;
        }
    };
    private final PrintWriter writer;
    private final Formatter formatter;

    public PrinterLogHandler(PrintWriter writer) {
        this.writer = writer;
        this.formatter = new Formatter(writer);
    }

    @Override
    public void onLog(LogEntry logEntry) {
        String utc = this.timestampToUTC(logEntry.getTimestamp());
        this.formatter.format("%s %-5s %s [%s] [%s] %s:%s(%s:%d) - %s\n", utc, logEntry.getLogLevel().name(), this.getShortenLoggerName(logEntry.getLoggerName()), logEntry.getHost(), logEntry.getThreadName(), this.getSimpleClassName(logEntry.getSourceClassName()), logEntry.getSourceMethodName(), logEntry.getFileName(), logEntry.getLineNumber(), logEntry.getMessage());
        this.formatter.flush();
        LogThrowable throwable = logEntry.getThrowable();
        while (throwable != null) {
            this.writer.append(throwable.getClassName()).append(": ").append(throwable.getMessage());
            this.writer.println();
            StackTraceElement[] stackTraces = throwable.getStackTraces();
            if (stackTraces != null) {
                for (StackTraceElement stackTrace : stackTraces) {
                    this.writer.append("\tat ").append(stackTrace.toString());
                    this.writer.println();
                }
            }
            if ((throwable = throwable.getCause()) == null) continue;
            this.writer.append("Caused by: ");
        }
        this.writer.flush();
    }

    private String timestampToUTC(long timestamp) {
        return DATE_FORMAT.get().format(new Date(timestamp));
    }

    private String getShortenLoggerName(String loggerName) {
        StringBuilder builder = new StringBuilder();
        String previous = null;
        for (String part : DOT_SPLIT.split(loggerName)) {
            if (previous != null) {
                builder.append(previous.charAt(0)).append('.');
            }
            previous = part;
        }
        return builder.append(previous).toString();
    }

    private String getSimpleClassName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }
}

