/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.runtime;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.distributed.AbstractClientProvider;
import org.apache.tephra.distributed.PooledClientProvider;
import org.apache.tephra.distributed.ThreadLocalClientProvider;
import org.apache.tephra.distributed.ThriftClientProvider;
import org.apache.tephra.shaded.org.apache.twill.discovery.DiscoveryServiceClient;

public class TransactionClientModule
extends AbstractModule {
    protected void configure() {
        this.bind(ThriftClientProvider.class).toProvider(ThriftClientProviderSupplier.class);
    }

    @Singleton
    private static final class ThriftClientProviderSupplier
    implements Provider<ThriftClientProvider> {
        private final Configuration cConf;
        private DiscoveryServiceClient discoveryServiceClient;

        @Inject
        ThriftClientProviderSupplier(Configuration cConf) {
            this.cConf = cConf;
        }

        @Inject(optional=true)
        void setDiscoveryServiceClient(DiscoveryServiceClient discoveryServiceClient) {
            this.discoveryServiceClient = discoveryServiceClient;
        }

        public ThriftClientProvider get() {
            AbstractClientProvider clientProvider;
            String provider = this.cConf.get("data.tx.client.provider", "pool");
            if ("pool".equals(provider)) {
                clientProvider = new PooledClientProvider(this.cConf, this.discoveryServiceClient);
            } else if ("thread-local".equals(provider)) {
                clientProvider = new ThreadLocalClientProvider(this.cConf, this.discoveryServiceClient);
            } else {
                String message = "Unknown Transaction Service Client Provider '" + provider + "'.";
                throw new IllegalArgumentException(message);
            }
            return clientProvider;
        }
    }
}

