/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical;

import java.util.List;
import java.util.Map;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;

public class LogicalPlanBuilder {
    private PlanProperties planProperties;
    private ImmutableMap.Builder<String, StoragePluginConfig> storageEngines = ImmutableMap.builder();
    private ImmutableList.Builder<LogicalOperator> operators = ImmutableList.builder();

    public LogicalPlanBuilder planProperties(PlanProperties planProperties) {
        this.planProperties = planProperties;
        return this;
    }

    public LogicalPlanBuilder planProperties(PlanProperties.PlanType type, int version, String generatorType, String generatorInfo, PlanProperties.Generator.ResultMode mode) {
        this.planProperties = PlanProperties.builder().generator(generatorType, generatorInfo).type(type).version(version).resultMode(mode).build();
        return this;
    }

    public LogicalPlanBuilder addStorageEngine(String name, StoragePluginConfig config) {
        this.storageEngines.put((Object)name, (Object)config);
        return this;
    }

    public LogicalPlanBuilder addLogicalOperator(LogicalOperator operator) {
        this.operators.add((Object)operator);
        return this;
    }

    public LogicalPlan build() {
        return new LogicalPlan(this.planProperties, (Map<String, StoragePluginConfig>)this.storageEngines.build(), (List<LogicalOperator>)this.operators.build());
    }
}

