/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.mongo.transform;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.bson.Document;

public abstract class OutputDataTransformer<T> {
    private final Map<String, MethodHandle> unitSetters;
    private final List<String> columns = new ArrayList<String>();
    private final List<Document> documents = new ArrayList<Document>();

    protected OutputDataTransformer(Map<String, MethodHandle> unitSetters) {
        this.unitSetters = unitSetters;
    }

    public OutputDataTransformer<T> columns(List<String> columns) {
        this.columns.addAll(columns);
        return this;
    }

    public OutputDataTransformer<T> documents(List<Document> documents) {
        this.documents.addAll(documents);
        return this;
    }

    public abstract List<T> execute();

    protected List<Map<MethodHandle, Object>> valuesToSet() {
        LinkedList results = Lists.newLinkedList();
        for (Document doc : this.documents) {
            HashMap handlerMap = Maps.newHashMap();
            for (Map.Entry entry : doc.entrySet()) {
                if (!this.unitSetters.containsKey(entry.getKey()) || !this.columns.isEmpty() && !this.columns.contains(entry.getKey())) continue;
                handlerMap.put(this.unitSetters.get(entry.getKey()), entry.getValue());
            }
            if (handlerMap.isEmpty()) continue;
            results.add(handlerMap);
        }
        return results;
    }
}

