/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.mongo.transform;

import com.mongodb.client.model.Filters;
import org.apache.drill.metastore.expressions.DoubleExpressionPredicate;
import org.apache.drill.metastore.expressions.FilterExpression;
import org.apache.drill.metastore.expressions.IsPredicate;
import org.apache.drill.metastore.expressions.ListPredicate;
import org.apache.drill.metastore.expressions.SimplePredicate;
import org.apache.drill.metastore.expressions.SingleExpressionPredicate;
import org.bson.conversions.Bson;

public class FilterExpressionVisitor
implements FilterExpression.Visitor<Bson> {
    private static final FilterExpressionVisitor INSTANCE = new FilterExpressionVisitor();

    public static FilterExpression.Visitor<Bson> get() {
        return INSTANCE;
    }

    public Bson visit(SimplePredicate.Equal<?> expression) {
        return Filters.eq((String)expression.column().columnName(), (Object)expression.value());
    }

    public Bson visit(SimplePredicate.NotEqual<?> expression) {
        return Filters.ne((String)expression.column().columnName(), (Object)expression.value());
    }

    public Bson visit(SimplePredicate.LessThan<?> expression) {
        return Filters.lt((String)expression.column().columnName(), (Object)expression.value());
    }

    public Bson visit(SimplePredicate.LessThanOrEqual<?> expression) {
        return Filters.lte((String)expression.column().columnName(), (Object)expression.value());
    }

    public Bson visit(SimplePredicate.GreaterThan<?> expression) {
        return Filters.gt((String)expression.column().columnName(), (Object)expression.value());
    }

    public Bson visit(SimplePredicate.GreaterThanOrEqual<?> expression) {
        return Filters.gte((String)expression.column().columnName(), (Object)expression.value());
    }

    public Bson visit(ListPredicate.In<?> expression) {
        return Filters.in((String)expression.column().columnName(), (Iterable)expression.values());
    }

    public Bson visit(ListPredicate.NotIn<?> expression) {
        return Filters.nin((String)expression.column().columnName(), (Iterable)expression.values());
    }

    public Bson visit(IsPredicate.IsNull expression) {
        return Filters.exists((String)expression.column().columnName(), (boolean)false);
    }

    public Bson visit(IsPredicate.IsNotNull expression) {
        return Filters.exists((String)expression.column().columnName());
    }

    public Bson visit(SingleExpressionPredicate.Not expression) {
        Bson child = (Bson)expression.expression().accept((FilterExpression.Visitor)this);
        return Filters.not((Bson)child);
    }

    public Bson visit(DoubleExpressionPredicate.And expression) {
        Bson right = (Bson)expression.right().accept((FilterExpression.Visitor)this);
        Bson left = (Bson)expression.left().accept((FilterExpression.Visitor)this);
        return Filters.and((Bson[])new Bson[]{right, left});
    }

    public Bson visit(DoubleExpressionPredicate.Or expression) {
        Bson right = (Bson)expression.right().accept((FilterExpression.Visitor)this);
        Bson left = (Bson)expression.left().accept((FilterExpression.Visitor)this);
        return Filters.or((Bson[])new Bson[]{right, left});
    }
}

