/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.metastore.Metastore;
import org.apache.drill.metastore.components.tables.Tables;
import org.apache.drill.metastore.components.views.Views;
import org.apache.drill.metastore.mongo.components.tables.MongoTables;
import org.bson.Document;

public class MongoMetastore
implements Metastore {
    private final MongoClient client;
    private final String database;
    private final String tableCollection;

    public MongoMetastore(DrillConfig config) {
        this.client = MongoClients.create((ConnectionString)new ConnectionString(config.getString("drill.metastore.mongo.connection")));
        this.database = config.hasPath("drill.metastore.mongo.database") ? config.getString("drill.metastore.mongo.database") : "meta";
        this.tableCollection = config.hasPath("drill.metastore.mongo.table_collection") ? config.getString("drill.metastore.mongo.table_collection") : "tables";
    }

    public Tables tables() {
        return new MongoTables((MongoCollection<Document>)this.client.getDatabase(this.database).getCollection(this.tableCollection), this.client);
    }

    public Views views() {
        throw new UnsupportedOperationException("Views metadata support is not implemented");
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

