/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.security.CredentialProviderUtils;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="jdbc")
@JsonFilter(value="passwordFilter")
public class JdbcStorageConfig
extends StoragePluginConfig {
    private static final Logger logger = LoggerFactory.getLogger(JdbcStorageConfig.class);
    public static final String NAME = "jdbc";
    public static final int DEFAULT_MAX_WRITER_BATCH_SIZE = 10000;
    private final String driver;
    private final String url;
    private final boolean caseInsensitiveTableNames;
    private final boolean writable;
    private final Map<String, Object> sourceParameters;
    private final int writerBatchSize;

    @JsonCreator
    public JdbcStorageConfig(@JsonProperty(value="driver") String driver, @JsonProperty(value="url") String url, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="caseInsensitiveTableNames") boolean caseInsensitiveTableNames, @JsonProperty(value="writable") boolean writable, @JsonProperty(value="sourceParameters") Map<String, Object> sourceParameters, @JsonProperty(value="credentialsProvider") CredentialsProvider credentialsProvider, @JsonProperty(value="authMode") String authMode, @JsonProperty(value="writerBatchSize") int writerBatchSize) {
        super(CredentialProviderUtils.getCredentialsProvider((String)username, (String)password, (CredentialsProvider)credentialsProvider), credentialsProvider == null, StoragePluginConfig.AuthMode.parseOrDefault((String)authMode, (StoragePluginConfig.AuthMode)StoragePluginConfig.AuthMode.SHARED_USER));
        this.driver = driver;
        this.url = url;
        this.writable = writable;
        this.caseInsensitiveTableNames = caseInsensitiveTableNames;
        this.sourceParameters = sourceParameters == null ? Collections.emptyMap() : sourceParameters;
        this.writerBatchSize = writerBatchSize == 0 ? 10000 : writerBatchSize;
    }

    private JdbcStorageConfig(JdbcStorageConfig that, CredentialsProvider credentialsProvider) {
        super(credentialsProvider, credentialsProvider == null, that.authMode);
        this.driver = that.driver;
        this.url = that.url;
        this.writable = that.writable;
        this.caseInsensitiveTableNames = that.caseInsensitiveTableNames;
        this.sourceParameters = that.sourceParameters;
        this.writerBatchSize = that.writerBatchSize;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        if (!this.directCredentials) {
            return null;
        }
        return this.getUsernamePasswordCredentials(null).map(UsernamePasswordCredentials::getUsername).orElse(null);
    }

    @JsonProperty(value="password")
    public String getPassword() {
        if (!this.directCredentials) {
            return null;
        }
        return this.getUsernamePasswordCredentials(null).map(UsernamePasswordCredentials::getPassword).orElse(null);
    }

    public JdbcStorageConfig updateCredentialProvider(CredentialsProvider credentialsProvider) {
        return new JdbcStorageConfig(this, credentialsProvider);
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean isWritable() {
        return this.writable;
    }

    public int getWriterBatchSize() {
        return this.writerBatchSize;
    }

    @JsonProperty(value="caseInsensitiveTableNames")
    public boolean areTableNamesCaseInsensitive() {
        return this.caseInsensitiveTableNames;
    }

    public Map<String, Object> getSourceParameters() {
        return this.sourceParameters;
    }

    @JsonIgnore
    public Optional<UsernamePasswordCredentials> getUsernamePasswordCredentials(UserBitShared.UserCredentials userCredentials) {
        switch (this.authMode) {
            case SHARED_USER: {
                return new UsernamePasswordCredentials.Builder().setCredentialsProvider(this.credentialsProvider).build();
            }
            case USER_TRANSLATION: {
                Preconditions.checkNotNull((Object)userCredentials, (Object)"A drill query user is required for user translation auth mode.");
                return new UsernamePasswordCredentials.Builder().setCredentialsProvider(this.credentialsProvider).setQueryUser(userCredentials.getUserName()).build();
            }
        }
        throw UserException.connectionError().message("This storage plugin does not support auth mode: %s", new Object[]{this.authMode}).build(logger);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.url, this.caseInsensitiveTableNames, this.sourceParameters, this.credentialsProvider, this.writable, this.writerBatchSize, this.authMode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JdbcStorageConfig that = (JdbcStorageConfig)((Object)o);
        return this.caseInsensitiveTableNames == that.caseInsensitiveTableNames && Objects.equals(this.driver, that.driver) && Objects.equals(this.url, that.url) && Objects.equals(this.writable, that.writable) && Objects.equals(this.sourceParameters, that.sourceParameters) && Objects.equals(this.credentialsProvider, that.credentialsProvider) && Objects.equals(this.writerBatchSize, that.writerBatchSize) && Objects.equals(this.authMode, that.authMode);
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("driver", this.driver).field("url", this.url).field("writable", (Object)this.writable).field("writerBatchSize", this.writerBatchSize).field("sourceParameters", this.sourceParameters).field("caseInsensitiveTableNames", (Object)this.caseInsensitiveTableNames).field("credentialProvider", (Object)this.credentialsProvider).field("authMode", (Object)this.authMode).toString();
    }
}

