/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.slf4j.LoggerFactory;

public class CpuGaugeSet
implements MetricSet {
    private final java.lang.management.OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private final RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();

    public Map<String, Metric> getMetrics() {
        Gauge<Double> osLoadAvgGauge = new Gauge<Double>(){

            public Double getValue() {
                return CpuGaugeSet.this.osMxBean.getSystemLoadAverage();
            }
        };
        Gauge<Double> procLoadAvgGauge = new Gauge<Double>(){
            private boolean canUseSunInternalBean = true;

            public Double getValue() {
                if (!this.canUseSunInternalBean) {
                    return null;
                }
                try {
                    return ((OperatingSystemMXBean)CpuGaugeSet.this.osMxBean).getProcessCpuLoad();
                }
                catch (ClassCastException | NoClassDefFoundError e) {
                    LoggerFactory.getLogger(CpuGaugeSet.class).warn("The process load gauge is not supported on this Java runtime: {}", (Object)System.getProperty("java.vm.name"));
                    this.canUseSunInternalBean = false;
                    return null;
                }
            }
        };
        Gauge<Long> uptimeGauge = new Gauge<Long>(){

            public Long getValue() {
                return CpuGaugeSet.this.runtimeMxBean.getUptime();
            }
        };
        return ImmutableMap.of((Object)"os.load.avg", (Object)osLoadAvgGauge, (Object)"drillbit.load.avg", (Object)procLoadAvgGauge, (Object)"drillbit.uptime", (Object)uptimeGauge);
    }
}

