/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.clienthints;

import com.esotericsoftware.kryo.Kryo;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzer;
import nl.basjes.parse.useragent.cache.DefaultClientHintsCacheInstantiator;
import nl.basjes.parse.useragent.clienthints.ClientHints;
import nl.basjes.parse.useragent.clienthints.parsers.BrandListParser;
import nl.basjes.parse.useragent.clienthints.parsers.CHParser;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUa;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaArch;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaBitness;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaFullVersion;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaFullVersionList;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaMobile;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaModel;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaPlatform;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaPlatformVersion;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaWoW64;
import nl.basjes.parse.useragent.utils.springframework.util.LinkedCaseInsensitiveMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientHintsHeadersParser
implements Serializable {
    public static final Logger LOG = LogManager.getFormatterLogger((String)"CHParser");
    private final Map<String, CHParser> parsers = new LinkedCaseInsensitiveMap<CHParser>();
    private final List<String> supportedClientHintHeaders;
    private final Map<String, Boolean> isSupportedClientHintHeader;
    private AbstractUserAgentAnalyzer.ClientHintsCacheInstantiator<?> clientHintsCacheInstantiator = null;
    private int clientHintsCacheSize = 1000;

    public ClientHintsHeadersParser() {
        this.addParser(new ParseSecChUa());
        this.addParser(new ParseSecChUaArch());
        this.addParser(new ParseSecChUaBitness());
        this.addParser(new ParseSecChUaFullVersion());
        this.addParser(new ParseSecChUaFullVersionList());
        this.addParser(new ParseSecChUaMobile());
        this.addParser(new ParseSecChUaModel());
        this.addParser(new ParseSecChUaPlatform());
        this.addParser(new ParseSecChUaPlatformVersion());
        this.addParser(new ParseSecChUaWoW64());
        this.supportedClientHintHeaders = this.parsers.values().stream().map(CHParser::inputField).distinct().collect(Collectors.toList());
        this.isSupportedClientHintHeader = new LinkedCaseInsensitiveMap<Boolean>();
        for (String header : this.supportedClientHintHeaders) {
            this.isSupportedClientHintHeader.put(header, Boolean.TRUE);
        }
    }

    public List<String> supportedClientHintHeaders() {
        return this.supportedClientHintHeaders;
    }

    public boolean isSupportedClientHintHeader(String header) {
        return this.isSupportedClientHintHeader.containsKey(header);
    }

    private void addParser(CHParser parser) {
        String field = parser.inputField();
        this.parsers.put(field, parser);
    }

    public static void configureKryo(Object kryoInstance) {
        Kryo kryo = (Kryo)kryoInstance;
        kryo.register(ClientHintsHeadersParser.class);
        kryo.register(DefaultClientHintsCacheInstantiator.class);
        kryo.register(ClientHints.class);
        kryo.register(BrandListParser.class);
        kryo.register(CHParser.class);
        kryo.register(ParseSecChUa.class);
        kryo.register(ParseSecChUaArch.class);
        kryo.register(ParseSecChUaBitness.class);
        kryo.register(ParseSecChUaFullVersion.class);
        kryo.register(ParseSecChUaFullVersionList.class);
        kryo.register(ParseSecChUaMobile.class);
        kryo.register(ParseSecChUaModel.class);
        kryo.register(ParseSecChUaPlatform.class);
        kryo.register(ParseSecChUaPlatformVersion.class);
        kryo.register(ParseSecChUaWoW64.class);
    }

    public ClientHints parse(Map<String, String> requestHeaders) {
        ClientHints clientHints = new ClientHints();
        for (Map.Entry<String, String> headerEntry : requestHeaders.entrySet()) {
            String headerName = headerEntry.getKey();
            CHParser parser = this.parsers.get(headerName);
            if (parser == null) continue;
            parser.parse(requestHeaders, clientHints, headerName);
        }
        return clientHints;
    }

    public String toString() {
        return "ClientHintAnalyzer:" + this.getClass().getSimpleName();
    }

    public int getCacheSize() {
        return this.clientHintsCacheSize;
    }

    public void setCacheSize(int newClientHintsCacheSize) {
        this.clearCache();
        this.clientHintsCacheSize = newClientHintsCacheSize = Math.max(newClientHintsCacheSize, 0);
    }

    public void setCacheInstantiator(AbstractUserAgentAnalyzer.ClientHintsCacheInstantiator<?> newClientHintsCacheInstantiator) {
        this.clientHintsCacheInstantiator = newClientHintsCacheInstantiator;
    }

    public synchronized void initializeCache() {
        if (this.clientHintsCacheInstantiator == null) {
            this.clientHintsCacheInstantiator = new DefaultClientHintsCacheInstantiator();
        }
        this.parsers.values().forEach(parser -> parser.initializeCache(this.clientHintsCacheInstantiator, this.clientHintsCacheSize));
    }

    public synchronized void clearCache() {
        this.parsers.values().forEach(CHParser::clearCache);
    }
}

