// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite("nereids_win_fn") {
    sql 'use regression_test_nereids_function_p0'
    sql 'set enable_nereids_planner=true'
    sql 'set enable_fallback_to_original_planner=false'
    // the sqls noted with tag containing 'ob' are unfixed result. others are core.
    // qt_sql_count '''
    // 	select count(kbint) over() as wf from fn_test'''
//    qt_sql_count_ob '''
//		select kint, count(kbint) over(order by kint) as wf from fn_test'''
    qt_sql_count_pb '''
		select kstr, count(kbint) over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_count_pb_ob '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_count_notnull '''
    // 	select count(kbint) over() as wf from fn_test_not_nullable'''
//    qt_sql_count_ob_notnull '''
//		select kint, count(kbint) over(order by kint) as wf from fn_test_not_nullable'''
    qt_sql_count_pb_notnull '''
		select kstr, count(kbint) over(partition by kstr) as wf from fn_test_not_nullable order by kstr'''
    qt_sql_count_pb_ob_notnull '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint) as wf from fn_test_not_nullable order by kstr, kint'''
    qt_sql_count_f_1 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows unbounded preceding) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_1 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows unbounded preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_2 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows 2 preceding) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_2 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows 2 preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_3 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows current row) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_3 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_4 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_4 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_5 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_5 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_6 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_6 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_7 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_7 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_8 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_8 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_9 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_9 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_10 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_10 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_11 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_11 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_12 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_12 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_13 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint range unbounded preceding) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_13 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint range unbounded preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_14 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_14 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_15 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_15 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_count_f_16 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test order by kint'''
    qt_sql_count_f_notnull_16 '''
		select kstr, kint, count(kbint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''

    // qt_sql_avg '''
    // 	select avg(kbint) over() as wf from fn_test'''
//    qt_sql_avg_ob '''
//		select kint, avg(kbint) over(order by kint) as wf from fn_test'''
    qt_sql_avg_pb '''
		select kstr, avg(kbint) over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_avg_pb_ob '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_avg_notnull '''
    // 	select avg(kbint) over() as wf from fn_test_not_nullable'''
//    qt_sql_avg_ob_notnull '''
//		select kint, avg(kbint) over(order by kint) as wf from fn_test_not_nullable'''
    qt_sql_avg_pb_notnull '''
		select kstr, avg(kbint) over(partition by kstr) as wf from fn_test_not_nullable order by kstr'''
    qt_sql_avg_pb_ob_notnull '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint) as wf from fn_test_not_nullable order by kstr, kint'''
    qt_sql_avg_f_1 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows unbounded preceding) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_1 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows unbounded preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_2 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows 2 preceding) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_2 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows 2 preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_3 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows current row) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_3 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_4 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_4 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_5 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_5 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_6 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_6 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_7 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_7 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_8 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_8 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_9 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_9 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_10 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_10 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_11 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_11 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_12 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_12 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_13 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint range unbounded preceding) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_13 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint range unbounded preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_14 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_14 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_15 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_15 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_avg_f_16 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test order by kint'''
    qt_sql_avg_f_notnull_16 '''
		select kstr, kint, avg(kbint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''

    // qt_sql_min '''
    // 	select min(kbint) over() as wf from fn_test'''
//    qt_sql_min_ob '''
//		select kint, min(kbint) over(order by kint) as wf from fn_test'''
    qt_sql_min_pb '''
		select kstr, min(kbint) over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_min_pb_ob '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_min_notnull '''
    // 	select min(kbint) over() as wf from fn_test_not_nullable'''
//    qt_sql_min_ob_notnull '''
//		select kint, min(kbint) over(order by kint) as wf from fn_test_not_nullable'''
    qt_sql_min_pb_notnull '''
		select kstr, min(kbint) over(partition by kstr) as wf from fn_test_not_nullable order by kstr'''
    qt_sql_min_pb_ob_notnull '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint) as wf from fn_test_not_nullable order by kstr, kint'''
    qt_sql_min_f_1 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_min_f_notnull_1 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_min_f_2 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_min_f_notnull_2 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_min_f_3 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_min_f_notnull_3 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_min_f_4 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test order by kint'''
    qt_sql_min_f_notnull_4 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_min_f_5 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_min_f_notnull_5 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_min_f_6 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_min_f_notnull_6 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_min_f_7 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test order by kint'''
    qt_sql_min_f_notnull_7 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_min_f_8 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test order by kint'''
    qt_sql_min_f_notnull_8 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_min_f_9 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test order by kint'''
    qt_sql_min_f_notnull_9 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_min_f_10 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_min_f_notnull_10 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_min_f_11 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_min_f_notnull_11 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_min_f_12 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test order by kint'''
    qt_sql_min_f_notnull_12 '''
		select kstr, kint, min(kbint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''

    // qt_sql_max '''
    // 	select max(kbint) over() as wf from fn_test'''
//    qt_sql_max_ob '''
//		select kint, max(kbint) over(order by kint) as wf from fn_test'''
    qt_sql_max_pb '''
		select kstr, max(kbint) over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_max_pb_ob '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_max_notnull '''
    // 	select max(kbint) over() as wf from fn_test_not_nullable'''
//    qt_sql_max_ob_notnull '''
//		select kint, max(kbint) over(order by kint) as wf from fn_test_not_nullable'''
    qt_sql_max_pb_notnull '''
		select kstr, max(kbint) over(partition by kstr) as wf from fn_test_not_nullable order by kstr'''
    qt_sql_max_pb_ob_notnull '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint) as wf from fn_test_not_nullable order by kstr, kint'''
    qt_sql_max_f_1 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_max_f_notnull_1 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_max_f_2 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_max_f_notnull_2 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_max_f_3 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_max_f_notnull_3 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_max_f_4 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test order by kint'''
    qt_sql_max_f_notnull_4 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_max_f_5 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_max_f_notnull_5 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_max_f_6 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_max_f_notnull_6 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_max_f_7 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test order by kint'''
    qt_sql_max_f_notnull_7 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_max_f_8 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test order by kint'''
    qt_sql_max_f_notnull_8 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_max_f_9 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test order by kint'''
    qt_sql_max_f_notnull_9 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_max_f_10 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_max_f_notnull_10 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_max_f_11 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_max_f_notnull_11 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_max_f_12 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test order by kint'''
    qt_sql_max_f_notnull_12 '''
		select kstr, kint, max(kbint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''

    // qt_sql_sum '''
    // 	select sum(kbint) over() as wf from fn_test'''
//    qt_sql_sum_ob '''
//		select kint, sum(kbint) over(order by kint) as wf from fn_test'''
    qt_sql_sum_pb '''
		select kstr, sum(kbint) over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_sum_pb_ob '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_sum_notnull '''
    // 	select sum(kbint) over() as wf from fn_test_not_nullable'''
//    qt_sql_sum_ob_notnull '''
//		select kint, sum(kbint) over(order by kint) as wf from fn_test_not_nullable'''
    qt_sql_sum_pb_notnull '''
		select kstr, sum(kbint) over(partition by kstr) as wf from fn_test_not_nullable  order by kstr'''
    qt_sql_sum_pb_ob_notnull '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint) as wf from fn_test_not_nullable  order by kstr, kint'''
    qt_sql_sum_f_1 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows unbounded preceding) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_1 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows unbounded preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_2 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows 2 preceding) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_2 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows 2 preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_3 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows current row) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_3 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_4 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_4 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_5 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_5 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_6 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_6 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_7 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_7 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_8 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_8 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_9 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_9 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_10 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_10 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_11 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_11 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_12 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_12 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_13 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint range unbounded preceding) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_13 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint range unbounded preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_14 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_14 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_15 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_15 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_sum_f_16 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test order by kint'''
    qt_sql_sum_f_notnull_16 '''
		select kstr, kint, sum(kbint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''

    // qt_sql_dense_rank '''
    // 	select dense_rank() over() as wf from fn_test'''
//    qt_sql_dense_rank_ob '''
//		select kint, dense_rank() over(order by kint) as wf from fn_test'''
    qt_sql_dense_rank_pb '''
		select kstr, dense_rank() over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_dense_rank_pb_ob '''
		select kstr, kint, dense_rank() over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_dense_rank_notnull '''
    // 	select dense_rank() over() as wf from fn_test_not_nullable'''
//    qt_sql_dense_rank_ob_notnull '''
//		select kint, dense_rank() over(order by kint) as wf from fn_test_not_nullable'''
    qt_sql_dense_rank_pb_notnull '''
		select kstr, dense_rank() over(partition by kstr) as wf from fn_test_not_nullable  order by kstr'''
    qt_sql_dense_rank_pb_ob_notnull '''
		select kstr, kint, dense_rank() over(partition by kstr order by kint) as wf from fn_test_not_nullable  order by kstr, kint'''

    // qt_sql_first_value '''
    // 	select first_value(kint) over() as wf from fn_test'''
//    qt_sql_first_value_ob '''
//		select kint, first_value(kint) over(order by kint) as wf from fn_test'''
    sql '''
		select kstr, first_value(kint) over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_first_value_pb_ob '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_first_value_notnull '''
    // 	select first_value(kint) over() as wf from fn_test_not_nullable'''
//    qt_sql_first_value_ob_notnull '''
//		select kint, first_value(kint) over(order by kint) as wf from fn_test_not_nullable'''
    sql '''
		select kstr, first_value(kint) over(partition by kstr) as wf from fn_test_not_nullable  order by kstr'''
    qt_sql_first_value_pb_ob_notnull '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint) as wf from fn_test_not_nullable  order by kstr, kint'''
    qt_sql_first_value_f_1 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows unbounded preceding) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_1 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows unbounded preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_2 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows 2 preceding) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_2 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows 2 preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_3 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows current row) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_3 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_4 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_4 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_5 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_5 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_6 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_6 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_7 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_7 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_8 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_8 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_9 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_9 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_10 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_10 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_11 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_11 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_12 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_12 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_13 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint range unbounded preceding) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_13 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint range unbounded preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_14 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_14 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_first_value_f_15 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_first_value_f_notnull_15 '''
		select kstr, kint, first_value(kint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    // qt_sql_first_value_f_16 '''
    // 	select kstr, kint, first_value(kint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test order by kint'''
    // qt_sql_first_value_f_notnull_16 '''
    // 	select kstr, kint, first_value(kint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''

    // qt_sql_lag '''
    // 	select lag(kint, 2, 1) over() as wf from fn_test'''
//    qt_sql_lag_ob '''
//		select kint, lag(kint, 2, 1) over(order by kint) as wf from fn_test'''
    sql '''
		select kstr, lag(kint, 2, 1) over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_lag_pb_ob '''
		select kstr, kint, lag(kint, 2, 1) over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_lag_notnull '''
    // 	select lag(kint, 2, 1) over() as wf from fn_test_not_nullable'''
//    qt_sql_lag_ob_notnull '''
//		select kint, lag(kint, 2, 1) over(order by kint) as wf from fn_test_not_nullable'''
    sql '''
		select kstr, lag(kint, 2, 1) over(partition by kstr) as wf from fn_test_not_nullable  order by kstr'''
    qt_sql_lag_pb_ob_notnull '''
		select kstr, kint, lag(kint, 2, 1) over(partition by kstr order by kint) as wf from fn_test_not_nullable  order by kstr, kint'''

    // qt_sql_last_value '''
    // 	select last_value(kint) over() as wf from fn_test'''
//    qt_sql_last_value_ob '''
//		select kint, last_value(kint) over(order by kint) as wf from fn_test'''
    sql '''
		select kstr, last_value(kint) over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_last_value_pb_ob '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_last_value_notnull '''
    // 	select last_value(kint) over() as wf from fn_test_not_nullable'''
//    qt_sql_last_value_ob_notnull '''
//		select kint, last_value(kint) over(order by kint) as wf from fn_test_not_nullable'''
    sql '''
		select kstr, last_value(kint) over(partition by kstr) as wf from fn_test_not_nullable  order by kstr'''
    qt_sql_last_value_pb_ob_notnull '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint) as wf from fn_test_not_nullable order by kstr, kint'''
    qt_sql_last_value_f_1 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows unbounded preceding) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_1 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows unbounded preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_2 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows 2 preceding) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_2 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows 2 preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_3 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows current row) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_3 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_4 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_4 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_5 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_5 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between unbounded preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_6 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_6 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_7 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_7 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between 2 preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_8 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_8 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between 2 preceding and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_9 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_9 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between 2 preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_10 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_10 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between current row and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_11 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_11 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between current row and 2 following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_12 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_12 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint rows between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_13 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint range unbounded preceding) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_13 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint range unbounded preceding) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_14 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_14 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint range between unbounded preceding and current row) as wf from fn_test_not_nullable order by kint'''
    qt_sql_last_value_f_15 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test order by kint'''
    qt_sql_last_value_f_notnull_15 '''
		select kstr, kint, last_value(kint) over(partition by kstr order by kint range between unbounded preceding and unbounded following) as wf from fn_test_not_nullable order by kint'''
    // qt_sql_last_value_f_16 '''
    // 	select kstr, kint, last_value(kint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test order by kint'''
    // qt_sql_last_value_f_notnull_16 '''
    // 	select kstr, kint, last_value(kint) over(partition by kstr order by kint range between current row and unbounded following) as wf from fn_test_not_nullable order by kint'''

    // qt_sql_lead '''
    // 	select lead(kint, 2, 1) over() as wf from fn_test'''
//    qt_sql_lead_ob '''
//		select kint, lead(kint, 2, 1) over(order by kint) as wf from fn_test'''
    sql '''
		select kstr, lead(kint, 2, 1) over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_lead_pb_ob '''
		select kstr, kint, lead(kint, 2, 1) over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_lead_notnull '''
    // 	select lead(kint, 2, 1) over() as wf from fn_test_not_nullable'''
//    qt_sql_lead_ob_notnull '''
//		select kint, lead(kint, 2, 1) over(order by kint) as wf from fn_test_not_nullable'''
    sql '''
		select kstr, lead(kint, 2, 1) over(partition by kstr) as wf from fn_test_not_nullable  order by kstr'''
    qt_sql_lead_pb_ob_notnull '''
		select kstr, kint, lead(kint, 2, 1) over(partition by kstr order by kint) as wf from fn_test_not_nullable order by kstr, kint'''

    // qt_sql_ntile '''
    // 	select ntile(3) over() as wf from fn_test'''
//    qt_sql_ntile_ob '''
//		select kint, ntile(3) over(order by kint) as wf from fn_test'''
    qt_sql_ntile_pb '''
		select kstr, ntile(3) over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_ntile_pb_ob '''
		select kstr, kint, ntile(3) over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_ntile_notnull '''
    // 	select ntile(3) over() as wf from fn_test_not_nullable'''
//    qt_sql_ntile_ob_notnull '''
//		select kint, ntile(3) over(order by kint) as wf from fn_test_not_nullable'''
    qt_sql_ntile_pb_notnull '''
		select kstr, ntile(3) over(partition by kstr) as wf from fn_test_not_nullable  order by kstr'''
    qt_sql_ntile_pb_ob_notnull '''
		select kstr, kint, ntile(3) over(partition by kstr order by kint) as wf from fn_test_not_nullable order by kstr, kint'''

    // qt_sql_rank '''
    // 	select rank() over() as wf from fn_test'''
//    qt_sql_rank_ob '''
//		select kint, rank() over(order by kint) as wf from fn_test'''
    qt_sql_rank_pb '''
		select kstr, rank() over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_rank_pb_ob '''
		select kstr, kint, rank() over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_rank_notnull '''
    // 	select rank() over() as wf from fn_test_not_nullable'''
//    qt_sql_rank_ob_notnull '''
//		select kint, rank() over(order by kint) as wf from fn_test_not_nullable'''
    qt_sql_rank_pb_notnull '''
		select kstr, rank() over(partition by kstr) as wf from fn_test_not_nullable  order by kstr'''
    qt_sql_rank_pb_ob_notnull '''
		select kstr, kint, rank() over(partition by kstr order by kint) as wf from fn_test_not_nullable order by kstr, kint'''

    qt_sql_percent_rank_pb '''
		select kstr, percent_rank() over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_percent_rank_pb_ob '''
		select kstr, kint, percent_rank() over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    
    qt_sql_percent_rank_pb_notnull '''
		select kstr, percent_rank() over(partition by kstr) as wf from fn_test_not_nullable  order by kstr'''
    qt_sql_percent_rank_pb_ob_notnull '''
		select kstr, kint, percent_rank() over(partition by kstr order by kint) as wf from fn_test_not_nullable order by kstr, kint'''

    qt_sql_cume_dist_pb '''
		select kstr, cume_dist() over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_cume_dist_pb_ob '''
		select kstr, kint, cume_dist() over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    
    qt_sql_cume_dist_pb_notnull '''
		select kstr, cume_dist() over(partition by kstr) as wf from fn_test_not_nullable  order by kstr'''
    qt_sql_cume_dist_pb_ob_notnull '''
		select kstr, kint, cume_dist() over(partition by kstr order by kint) as wf from fn_test_not_nullable order by kstr, kint'''

    // qt_sql_row_number '''
    // 	select row_number() over() as wf from fn_test'''
//    qt_sql_row_number_ob '''
//		select kint, row_number() over(order by kint) as wf from fn_test'''
    qt_sql_row_number_pb '''
		select kstr, row_number() over(partition by kstr) as wf from fn_test order by kstr'''
    qt_sql_row_number_pb_ob '''
		select kstr, kint, row_number() over(partition by kstr order by kint) as wf from fn_test order by kstr, kint'''
    // qt_sql_row_number_notnull '''
    // 	select row_number() over() as wf from fn_test_not_nullable'''
//    qt_sql_row_number_ob_notnull '''
//		select kint, row_number() over(order by kint) as wf from fn_test_not_nullable'''
    qt_sql_row_number_pb_notnull '''
		select kstr, row_number() over(partition by kstr) as wf from fn_test_not_nullable order by kstr'''
    qt_sql_row_number_pb_ob_notnull '''
		select kstr, kint, row_number() over(partition by kstr order by kint) as wf from fn_test_not_nullable order by kstr, kint'''

}
