// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.scalar;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.AlwaysNullable;
import org.apache.doris.nereids.trees.expressions.functions.ComputePrecisionForArrayItemAgg;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.shape.UnaryExpression;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.ArrayType;
import org.apache.doris.nereids.types.BigIntType;
import org.apache.doris.nereids.types.BooleanType;
import org.apache.doris.nereids.types.DecimalV2Type;
import org.apache.doris.nereids.types.DecimalV3Type;
import org.apache.doris.nereids.types.DoubleType;
import org.apache.doris.nereids.types.FloatType;
import org.apache.doris.nereids.types.IntegerType;
import org.apache.doris.nereids.types.LargeIntType;
import org.apache.doris.nereids.types.SmallIntType;
import org.apache.doris.nereids.types.TinyIntType;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * ScalarFunction 'array_avg'. This class is generated by GenerateFunction.
 */
public class ArrayAvg extends ScalarFunction implements ExplicitlyCastableSignature,
        ComputePrecisionForArrayItemAgg, UnaryExpression, AlwaysNullable {

    public static final List<FunctionSignature> SIGNATURES = ImmutableList.of(
            FunctionSignature.ret(DoubleType.INSTANCE).args(ArrayType.of(DoubleType.INSTANCE)),
            FunctionSignature.ret(DoubleType.INSTANCE).args(ArrayType.of(BooleanType.INSTANCE)),
            FunctionSignature.ret(DoubleType.INSTANCE).args(ArrayType.of(TinyIntType.INSTANCE)),
            FunctionSignature.ret(DoubleType.INSTANCE).args(ArrayType.of(SmallIntType.INSTANCE)),
            FunctionSignature.ret(DoubleType.INSTANCE).args(ArrayType.of(IntegerType.INSTANCE)),
            FunctionSignature.ret(DoubleType.INSTANCE).args(ArrayType.of(BigIntType.INSTANCE)),
            FunctionSignature.ret(DoubleType.INSTANCE).args(ArrayType.of(LargeIntType.INSTANCE)),
            FunctionSignature.ret(DecimalV3Type.WILDCARD).args(ArrayType.of(DecimalV3Type.WILDCARD)),
            FunctionSignature.ret(DecimalV2Type.SYSTEM_DEFAULT).args(ArrayType.of(DecimalV2Type.SYSTEM_DEFAULT)),
            FunctionSignature.ret(DoubleType.INSTANCE).args(ArrayType.of(FloatType.INSTANCE))
    );

    /**
     * constructor with 1 argument.
     */
    public ArrayAvg(Expression arg) {
        super("array_avg", arg);
    }

    // TODO use this computePrecision if be support dynamic scale
    // @Override
    // public FunctionSignature computePrecision(FunctionSignature signature) {
    //     DataType argumentType = getArgumentType(0);
    //     if (argumentType instanceof ArrayType) {
    //         DataType argType = ((ArrayType) argumentType).getItemType();
    //         DataType sigType = ((ArrayType) signature.getArgType(0)).getItemType();
    //         if (sigType instanceof DecimalV3Type) {
    //             DecimalV3Type decimalV3Type = DecimalV3Type.forType(argType);
    //             // DecimalV3 scale lower than DEFAULT_MIN_AVG_DECIMAL128_SCALE should do cast
    //             int precision = decimalV3Type.getPrecision();
    //             int scale = decimalV3Type.getScale();
    //             if (decimalV3Type.getScale() < ScalarType.DEFAULT_MIN_AVG_DECIMAL128_SCALE) {
    //                 scale = ScalarType.DEFAULT_MIN_AVG_DECIMAL128_SCALE;
    //                 precision = precision - decimalV3Type.getScale() + scale;
    //                 if (precision > DecimalV3Type.MAX_DECIMAL128_PRECISION) {
    //                     precision = DecimalV3Type.MAX_DECIMAL128_PRECISION;
    //                 }
    //             }
    //             decimalV3Type = DecimalV3Type.createDecimalV3Type(precision, scale);
    //             return signature.withArgumentType(0, ArrayType.of(decimalV3Type))
    //                     .withReturnType(ArrayType.of(DecimalV3Type.createDecimalV3Type(
    //                             DecimalV3Type.MAX_DECIMAL128_PRECISION, decimalV3Type.getScale()
    //                     )));
    //         }
    //     }
    //     return signature;
    // }

    /**
     * withChildren.
     */
    @Override
    public ArrayAvg withChildren(List<Expression> children) {
        Preconditions.checkArgument(children.size() == 1);
        return new ArrayAvg(children.get(0));
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitArrayAvg(this, context);
    }

    @Override
    public List<FunctionSignature> getSignatures() {
        return SIGNATURES;
    }
}
