/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.config.view;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.spi.config.view.ConfigDescriptorValidator;
import org.apache.deltaspike.jsf.impl.config.view.DefaultViewConfigResolver;
import org.apache.deltaspike.jsf.impl.config.view.FolderConfigNode;
import org.apache.deltaspike.jsf.impl.config.view.ViewConfigExtension;

@ApplicationScoped
public class ViewConfigResolverProducer {
    private static final Logger LOG = Logger.getLogger(ViewConfigResolverProducer.class.getName());
    @Inject
    private ViewConfigExtension viewConfigExtension;

    public ViewConfigResolverProducer() {
    }

    public ViewConfigResolverProducer(ViewConfigExtension viewConfigExtension) {
        this.viewConfigExtension = viewConfigExtension;
    }

    @Produces
    @ApplicationScoped
    public ViewConfigResolver createViewConfigResolver() {
        ViewConfigResolver viewConfigResolver;
        if (!this.viewConfigExtension.isActivated()) {
            return this.createEmptyDefaultViewConfigResolver();
        }
        if (!this.viewConfigExtension.isTransformed()) {
            this.viewConfigExtension.transformMetaDataTree();
        }
        if ((viewConfigResolver = this.viewConfigExtension.getViewConfigResolver()) == null) {
            LOG.warning("It wasn't possible to create a ViewConfigResolver");
            viewConfigResolver = this.createEmptyDefaultViewConfigResolver();
        }
        return viewConfigResolver;
    }

    private DefaultViewConfigResolver createEmptyDefaultViewConfigResolver() {
        return new DefaultViewConfigResolver(new FolderConfigNode(null, null, new HashSet<Annotation>()), null, null, new ArrayList<ConfigDescriptorValidator>());
    }
}

