/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.AbstractDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEvent;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.behavior.IStatElement;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class JDBCDiskCache<K, V>
extends AbstractDiskCache<K, V> {
    private static final Log log = LogManager.getLog(JDBCDiskCache.class);
    private JDBCDiskCacheAttributes jdbcDiskCacheAttributes;
    private final AtomicInteger updateCount = new AtomicInteger(0);
    private final AtomicInteger getCount = new AtomicInteger(0);
    private final AtomicInteger getMatchingCount = new AtomicInteger(0);
    private final DataSourceFactory dsFactory;
    private TableState tableState;

    public JDBCDiskCache(JDBCDiskCacheAttributes cattr, DataSourceFactory dsFactory, TableState tableState) {
        super(cattr);
        this.setTableState(tableState);
        this.setJdbcDiskCacheAttributes(cattr);
        log.info("jdbcDiskCacheAttributes = {0}", this::getJdbcDiskCacheAttributes);
        this.dsFactory = dsFactory;
        this.setAlive(true);
    }

    @Override
    protected void processUpdate(ICacheElement<K, V> ce) {
        this.updateCount.incrementAndGet();
        log.debug("updating, ce = {0}", ce);
        try (Connection con = this.getDataSource().getConnection();){
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = ce::getKey;
            log.debug("Putting [{0}] on disk.", supplierArray);
            try {
                byte[] element = this.getElementSerializer().serialize(ce);
                this.insertOrUpdate(ce, con, element);
            }
            catch (IOException e) {
                log.error("Could not serialize element", e);
            }
        }
        catch (SQLException e) {
            log.error("Problem getting connection.", e);
        }
    }

    private void insertOrUpdate(ICacheElement<K, V> ce, Connection con, byte[] element) {
        boolean exists = false;
        if (this.getJdbcDiskCacheAttributes().isTestBeforeInsert()) {
            exists = this.doesElementExist(ce, con);
        }
        if (!exists) {
            exists = this.insertRow(ce, con, element);
        }
        if (exists) {
            this.updateRow(ce, con, element);
        }
    }

    private boolean insertRow(ICacheElement<K, V> ce, Connection con, byte[] element) {
        boolean exists;
        block16: {
            exists = false;
            String sqlI = String.format("insert into %s (CACHE_KEY, REGION, ELEMENT, MAX_LIFE_SECONDS, IS_ETERNAL, CREATE_TIME, UPDATE_TIME_SECONDS, SYSTEM_EXPIRE_TIME_SECONDS)  values (?, ?, ?, ?, ?, ?, ?, ?)", this.getJdbcDiskCacheAttributes().getTableName());
            try (PreparedStatement psInsert = con.prepareStatement(sqlI);){
                psInsert.setString(1, ce.getKey().toString());
                psInsert.setString(2, this.getCacheName());
                psInsert.setBytes(3, element);
                psInsert.setLong(4, ce.getElementAttributes().getMaxLife());
                psInsert.setString(5, ce.getElementAttributes().getIsEternal() ? "T" : "F");
                Timestamp createTime = new Timestamp(ce.getElementAttributes().getCreateTime());
                psInsert.setTimestamp(6, createTime);
                long now = System.currentTimeMillis() / 1000L;
                psInsert.setLong(7, now);
                long expireTime = now + ce.getElementAttributes().getMaxLife();
                psInsert.setLong(8, expireTime);
                psInsert.execute();
            }
            catch (SQLException e) {
                if ("23000".equals(e.getSQLState())) {
                    exists = true;
                } else {
                    log.error("Could not insert element", e);
                }
                if (exists || this.getJdbcDiskCacheAttributes().isTestBeforeInsert()) break block16;
                exists = this.doesElementExist(ce, con);
            }
        }
        return exists;
    }

    private void updateRow(ICacheElement<K, V> ce, Connection con, byte[] element) {
        String sqlU = String.format("update %s set ELEMENT  = ?, CREATE_TIME = ?, UPDATE_TIME_SECONDS = ?,  SYSTEM_EXPIRE_TIME_SECONDS = ?  where CACHE_KEY = ? and REGION = ?", this.getJdbcDiskCacheAttributes().getTableName());
        try (PreparedStatement psUpdate = con.prepareStatement(sqlU);){
            psUpdate.setBytes(1, element);
            Timestamp createTime = new Timestamp(ce.getElementAttributes().getCreateTime());
            psUpdate.setTimestamp(2, createTime);
            long now = System.currentTimeMillis() / 1000L;
            psUpdate.setLong(3, now);
            long expireTime = now + ce.getElementAttributes().getMaxLife();
            psUpdate.setLong(4, expireTime);
            psUpdate.setString(5, (String)ce.getKey());
            psUpdate.setString(6, this.getCacheName());
            psUpdate.execute();
            log.debug("ran update {0}", sqlU);
        }
        catch (SQLException e) {
            log.error("Error executing update sql [{0}]", sqlU, e);
        }
    }

    protected boolean doesElementExist(ICacheElement<K, V> ce, Connection con) {
        boolean exists = false;
        String sqlS = String.format("select CACHE_KEY from %s where REGION = ? and CACHE_KEY = ?", this.getJdbcDiskCacheAttributes().getTableName());
        try (PreparedStatement psSelect = con.prepareStatement(sqlS);){
            psSelect.setString(1, this.getCacheName());
            psSelect.setString(2, (String)ce.getKey());
            try (ResultSet rs = psSelect.executeQuery();){
                exists = rs.next();
            }
            log.debug("[{0}] existing status is {1}", ce.getKey(), exists);
        }
        catch (SQLException e) {
            log.error("Problem looking for item before insert.", e);
        }
        return exists;
    }

    @Override
    protected ICacheElement<K, V> processGet(K key) {
        this.getCount.incrementAndGet();
        log.debug("Getting [{0}] from disk", key);
        if (!this.isAlive()) {
            return null;
        }
        ICacheElement obj = null;
        String selectString = String.format("select ELEMENT from %s where REGION = ? and CACHE_KEY = ?", this.getJdbcDiskCacheAttributes().getTableName());
        try (Connection con = this.getDataSource().getConnection();
             PreparedStatement psSelect = con.prepareStatement(selectString);){
            psSelect.setString(1, this.getCacheName());
            psSelect.setString(2, key.toString());
            try (ResultSet rs = psSelect.executeQuery();){
                byte[] data = null;
                if (rs.next()) {
                    data = rs.getBytes(1);
                }
                if (data != null) {
                    try {
                        obj = (ICacheElement)this.getElementSerializer().deSerialize(data, null);
                    }
                    catch (IOException | ClassNotFoundException e) {
                        log.error("Problem getting item for key [{0}]", key, e);
                    }
                }
            }
        }
        catch (SQLException sqle) {
            log.error("Caught a SQL exception trying to get the item for key [{0}]", key, sqle);
        }
        return obj;
    }

    @Override
    protected Map<K, ICacheElement<K, V>> processGetMatching(String pattern) {
        HashMap results;
        block43: {
            this.getMatchingCount.incrementAndGet();
            log.debug("Getting [{0}] from disk", pattern);
            if (!this.isAlive()) {
                return null;
            }
            results = new HashMap();
            String selectString = String.format("select ELEMENT from %s where REGION = ? and CACHE_KEY like ?", this.getJdbcDiskCacheAttributes().getTableName());
            try (Connection con = this.getDataSource().getConnection();
                 PreparedStatement psSelect = con.prepareStatement(selectString);){
                psSelect.setString(1, this.getCacheName());
                psSelect.setString(2, this.constructLikeParameterFromPattern(pattern));
                ResultSet rs = psSelect.executeQuery();
                Throwable throwable = null;
                block31: while (true) {
                    try {
                        while (rs.next()) {
                            byte[] data = rs.getBytes(1);
                            if (data == null) continue;
                            try {
                                ICacheElement value = (ICacheElement)this.getElementSerializer().deSerialize(data, null);
                                results.put(value.getKey(), value);
                                continue block31;
                            }
                            catch (IOException | ClassNotFoundException e) {
                                log.error("Problem getting items for pattern [{0}]", pattern, e);
                            }
                        }
                        break block43;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (SQLException sqle) {
                log.error("Caught a SQL exception trying to get items for pattern [{0}]", pattern, sqle);
            }
        }
        return results;
    }

    public String constructLikeParameterFromPattern(String pattern) {
        String likePattern = pattern.replace(".+", "%");
        likePattern = likePattern.replace(".", "_");
        log.debug("pattern = [{0}]", likePattern);
        return likePattern;
    }

    @Override
    protected boolean processRemove(K key) {
        String sqlSingle = String.format("delete from %s where REGION = ? and CACHE_KEY = ?", this.getJdbcDiskCacheAttributes().getTableName());
        String sqlPartial = String.format("delete from %s where REGION = ? and CACHE_KEY like ?", this.getJdbcDiskCacheAttributes().getTableName());
        try (Connection con = this.getDataSource().getConnection();){
            boolean partial = key.toString().endsWith(":");
            String sql = partial ? sqlPartial : sqlSingle;
            try (PreparedStatement psSelect = con.prepareStatement(sql);){
                psSelect.setString(1, this.getCacheName());
                if (partial) {
                    psSelect.setString(2, key.toString() + "%");
                } else {
                    psSelect.setString(2, key.toString());
                }
                psSelect.executeUpdate();
                this.setAlive(true);
            }
            catch (SQLException e) {
                log.error("Problem creating statement. sql [{0}]", sql, e);
                this.setAlive(false);
            }
        }
        catch (SQLException e) {
            log.error("Problem updating cache.", e);
            this.reset();
        }
        return false;
    }

    @Override
    protected void processRemoveAll() {
        if (this.jdbcDiskCacheAttributes.isAllowRemoveAll()) {
            String sql = String.format("delete from %s where REGION = ?", this.getJdbcDiskCacheAttributes().getTableName());
            try (Connection con = this.getDataSource().getConnection();){
                try (PreparedStatement psDelete = con.prepareStatement(sql);){
                    psDelete.setString(1, this.getCacheName());
                    this.setAlive(true);
                    psDelete.executeUpdate();
                }
                catch (SQLException e) {
                    log.error("Problem creating statement.", e);
                    this.setAlive(false);
                }
            }
            catch (SQLException e) {
                log.error("Problem removing all.", e);
                this.reset();
            }
        } else {
            log.info("RemoveAll was requested but the request was not fulfilled: allowRemoveAll is set to false.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deleteExpired() {
        int deleted;
        block33: {
            deleted = 0;
            try (Connection con = this.getDataSource().getConnection();){
                DatabaseMetaData dmd = con.getMetaData();
                ResultSet result = dmd.getTables(null, null, this.getJdbcDiskCacheAttributes().getTableName(), null);
                if (result.next()) {
                    this.getTableState().setState(1);
                    long now = System.currentTimeMillis() / 1000L;
                    String sql = String.format("delete from %s where IS_ETERNAL = ? and REGION = ? and ? > SYSTEM_EXPIRE_TIME_SECONDS", this.getJdbcDiskCacheAttributes().getTableName());
                    try (PreparedStatement psDelete = con.prepareStatement(sql);){
                        psDelete.setString(1, "F");
                        psDelete.setString(2, this.getCacheName());
                        psDelete.setLong(3, now);
                        this.setAlive(true);
                        deleted = psDelete.executeUpdate();
                    }
                    catch (SQLException e) {
                        log.error("Problem creating statement.", e);
                        this.setAlive(false);
                    }
                    this.logApplicationEvent(this.getAuxiliaryCacheAttributes().getName(), "deleteExpired", "Deleted expired elements.  URL: " + this.getDiskLocation());
                    break block33;
                }
                log.warn("Trying to shrink non-existing table [{0}]", this.getJdbcDiskCacheAttributes().getTableName());
            }
            catch (SQLException e) {
                this.logError(this.getAuxiliaryCacheAttributes().getName(), "deleteExpired", e.getMessage() + " URL: " + this.getDiskLocation());
                log.error("Problem removing expired elements from the table.", e);
                this.reset();
            }
            finally {
                this.getTableState().setState(0);
            }
        }
        return deleted;
    }

    public void reset() {
    }

    @Override
    public void processDispose() {
        ICacheEvent<Object> cacheEvent = this.createICacheEvent(this.getCacheName(), null, "dispose");
        try {
            this.dsFactory.close();
        }
        catch (SQLException e) {
            log.error("Problem shutting down.", e);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    @Override
    public int getSize() {
        int size = 0;
        String selectString = String.format("select count(*) from %s where REGION = ?", this.getJdbcDiskCacheAttributes().getTableName());
        try (Connection con = this.getDataSource().getConnection();
             PreparedStatement psSelect = con.prepareStatement(selectString);){
            psSelect.setString(1, this.getCacheName());
            try (ResultSet rs = psSelect.executeQuery();){
                if (rs.next()) {
                    size = rs.getInt(1);
                }
            }
        }
        catch (SQLException e) {
            log.error("Problem getting size.", e);
        }
        return size;
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        throw new UnsupportedOperationException("Groups not implemented.");
    }

    protected void setJdbcDiskCacheAttributes(JDBCDiskCacheAttributes jdbcDiskCacheAttributes) {
        this.jdbcDiskCacheAttributes = jdbcDiskCacheAttributes;
    }

    protected JDBCDiskCacheAttributes getJdbcDiskCacheAttributes() {
        return this.jdbcDiskCacheAttributes;
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.getJdbcDiskCacheAttributes();
    }

    @Override
    public IStats getStatistics() {
        IStats stats = super.getStatistics();
        stats.setTypeName("JDBC/Abstract Disk Cache");
        List<IStatElement<?>> elems = stats.getStatElements();
        elems.add(new StatElement<AtomicInteger>("Update Count", this.updateCount));
        elems.add(new StatElement<AtomicInteger>("Get Count", this.getCount));
        elems.add(new StatElement<AtomicInteger>("Get Matching Count", this.getMatchingCount));
        elems.add(new StatElement<String>("DB URL", this.getJdbcDiskCacheAttributes().getUrl()));
        stats.setStatElements(elems);
        return stats;
    }

    protected String getTableName() {
        String name = "UNDEFINED";
        if (this.getJdbcDiskCacheAttributes() != null) {
            name = this.getJdbcDiskCacheAttributes().getTableName();
        }
        return name;
    }

    public void setTableState(TableState tableState) {
        this.tableState = tableState;
    }

    public TableState getTableState() {
        return this.tableState;
    }

    @Override
    protected String getDiskLocation() {
        return this.jdbcDiskCacheAttributes.getUrl();
    }

    public DataSource getDataSource() throws SQLException {
        return this.dsFactory.getDataSource();
    }

    public String toString() {
        return this.getStats();
    }
}

