/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.control.existingtargetstrategy;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.UnitConfiguration;
import org.apache.torque.generator.control.ControllerException;
import org.apache.torque.generator.control.ControllerHelper;
import org.apache.torque.generator.control.existingtargetstrategy.ExistingTargetStrategy;
import org.apache.torque.generator.merge.ThreeWayMerger;
import org.apache.torque.generator.outlet.OutletResult;

public class MergeTargetFileStrategy
implements ExistingTargetStrategy {
    public static final String STRATEGY_NAME = "merge";
    public static final String WORK_SUBDIR = "raw-generated";
    private static Log log = LogFactory.getLog(MergeTargetFileStrategy.class);
    private final ThreeWayMerger merger = new ThreeWayMerger();

    @Override
    public boolean beforeGeneration(String outputDirKey, String outputPath, String encoding, UnitConfiguration unitConfiguration) {
        return true;
    }

    @Override
    public void afterGeneration(String outputDirKey, String outputPath, String encoding, OutletResult generationResult, UnitConfiguration unitConfiguration) throws GeneratorException {
        File generationStorageDir = new File(unitConfiguration.getWorkDirectory(), WORK_SUBDIR);
        File generationStorageFile = outputDirKey == null ? new File(generationStorageDir, FilenameUtils.concat((String)"default", (String)outputPath)) : new File(generationStorageDir, FilenameUtils.concat((String)"other", (String)FilenameUtils.concat((String)outputDirKey, (String)outputPath)));
        String oldGenerationContent = this.readFileToString(generationStorageFile, encoding);
        File targetFile = ControllerHelper.getOutputFile(outputDirKey, outputPath, unitConfiguration);
        String oldTargetContent = this.readFileToString(targetFile, encoding);
        if (!generationResult.isStringResult()) {
            throw new GeneratorException("The merge target file strategy onlys works for String generation results (target file=" + targetFile.getAbsolutePath() + ")");
        }
        String newTargetContent = null;
        if (oldTargetContent == null) {
            log.debug((Object)"no old target content found, using generation result");
            newTargetContent = generationResult.getStringResult();
        } else if (oldGenerationContent == null) {
            log.info((Object)"no old generation content found,using old target content. This is a bit unusual, but may be ok depending on the circumstances");
            newTargetContent = generationResult.getStringResult();
        } else {
            log.debug((Object)"merging generation result and old target content");
            newTargetContent = this.merger.merge(oldGenerationContent, generationResult.getStringResult(), oldTargetContent, encoding);
        }
        this.writeStringToFile(targetFile, newTargetContent, encoding);
        this.writeStringToFile(generationStorageFile, generationResult.getStringResult(), encoding);
    }

    @Override
    public String getStrategyName() {
        return STRATEGY_NAME;
    }

    private String readFileToString(File file, String charset) throws ControllerException {
        String result = null;
        if (file.exists()) {
            try {
                result = FileUtils.readFileToString((File)file, (String)charset);
            }
            catch (IOException e) {
                throw new ControllerException("Could not read file \"" + file.getAbsolutePath() + "\"", e);
            }
        }
        return result;
    }

    private void writeStringToFile(File file, String content, String charset) throws ControllerException {
        try {
            FileUtils.writeStringToFile((File)file, (String)content, (String)charset);
        }
        catch (IOException e) {
            throw new ControllerException("Could not write file \"" + file.getAbsolutePath() + "\"", e);
        }
    }
}

