/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.AbstractConfigurationProvider;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.PackageResources;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.paths.TorqueGeneratorPaths;

public class ClasspathConfigurationProvider
extends AbstractConfigurationProvider {
    private static Log log = LogFactory.getLog(ClasspathConfigurationProvider.class);
    private final UnitDescriptor unitDescriptor;

    public ClasspathConfigurationProvider(UnitDescriptor unitDescriptor) {
        super(unitDescriptor.getConfigurationPaths());
        this.unitDescriptor = unitDescriptor;
    }

    @Override
    public String getControlConfigurationLocation() {
        TorqueGeneratorPaths configurationPaths = this.unitDescriptor.getConfigurationPaths();
        return this.getFileName(configurationPaths.getControlConfigurationFile(), configurationPaths.getConfigurationDirectory());
    }

    protected String getFileName(String name, String directory) {
        String fileName = this.getConfigResourceBase() + "/" + directory + "/" + name;
        fileName = FilenameUtils.normalizeNoEndSeparator((String)fileName);
        fileName = FilenameUtils.separatorsToUnix((String)fileName);
        return fileName;
    }

    @Override
    protected InputStream getInputStream(String name, String directory, String fileDescription) throws ConfigurationException {
        InputStream inputStream;
        String fileName = this.getFileName(name, directory);
        ClassLoader classLoader = this.unitDescriptor.getClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((inputStream = classLoader.getResourceAsStream(fileName)) == null) {
            throw new ConfigurationException("Could not read " + fileDescription + " file " + fileName + " in classpath");
        }
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading " + fileDescription + " file: '" + fileName + "' in classpath"));
        }
        return bis;
    }

    @Override
    public Collection<String> getOutletConfigurationNames() throws ConfigurationException {
        String outletConfigurationSubdir = this.getConfigResourceBase() + "/" + this.unitDescriptor.getConfigurationPaths().getOutletDirectory();
        outletConfigurationSubdir = outletConfigurationSubdir.replace('\\', '/');
        PackageResources packageResources = new PackageResources(outletConfigurationSubdir, this.getClass().getClassLoader());
        return packageResources.getAllResourcesEndingWith(".xml", false);
    }

    @Override
    public Collection<String> getTemplateNames() throws ConfigurationException {
        String templatesConfigurationSubdir = this.getConfigResourceBase() + "/" + this.unitDescriptor.getConfigurationPaths().getTemplateDirectory();
        templatesConfigurationSubdir = templatesConfigurationSubdir.replace('\\', '/');
        PackageResources packageResources = new PackageResources(templatesConfigurationSubdir, this.getClass().getClassLoader());
        return packageResources.getAllResourcesEndingWith(null, true);
    }

    private String getConfigResourceBase() {
        String configResourceBase = this.unitDescriptor.getProjectPaths().getConfigurationPackage().replace('.', '/');
        return configResourceBase;
    }
}

