/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.controller;

import org.apache.commons.lang.StringUtils;
import org.apache.torque.generator.configuration.controller.OutletReference;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.source.SourceProcessConfiguration;
import org.apache.torque.generator.source.SourceProvider;

public class Output {
    private static final String CARRIAGE_RETURN = "\r";
    private static final String LINE_FEED = "\n";
    private static final String CARRIAGE_RETURN_LINE_FEED = "\r\n";
    private QualifiedName name;
    private SourceProvider sourceProvider;
    private SourceProcessConfiguration sourceProcessConfiguration;
    private OutletReference contentOutlet;
    private Outlet filenameOutlet;
    private String filename;
    private String existingTargetStrategy = "replace";
    private String type = "unknown";
    private String lineBreak;
    private String outputDirKey;
    private String encoding;

    public Output(QualifiedName name) {
        this.name = name;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public void setSourceProvider(SourceProvider sourceProvider) {
        this.sourceProvider = sourceProvider;
    }

    public SourceProcessConfiguration getSourceProcessConfiguration() {
        return this.sourceProcessConfiguration;
    }

    public void setSourceProcessConfiguration(SourceProcessConfiguration sourceProcessConfiguration) {
        this.sourceProcessConfiguration = sourceProcessConfiguration;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public OutletReference getContentOutlet() {
        return this.contentOutlet;
    }

    public void setContentOutlet(OutletReference contentOutlet) {
        this.contentOutlet = contentOutlet;
    }

    public Outlet getFilenameOutlet() {
        return this.filenameOutlet;
    }

    public void setFilenameOutlet(Outlet filenameOutlet) {
        this.filenameOutlet = filenameOutlet;
    }

    public String getExistingTargetStrategy() {
        return this.existingTargetStrategy;
    }

    public void setExistingTargetStrategy(String existingTargetStrategy) {
        this.existingTargetStrategy = existingTargetStrategy;
    }

    public String getOutputDirKey() {
        return this.outputDirKey;
    }

    public void setOutputDirKey(String outputKeyDir) {
        this.outputDirKey = outputKeyDir;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setType(String type) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getOrDetermineLineBreak(String content) {
        if (this.lineBreak != null) {
            return this.lineBreak;
        }
        String contentString = content.toString();
        int r = StringUtils.countMatches((String)contentString, (String)CARRIAGE_RETURN);
        int n = StringUtils.countMatches((String)contentString, (String)LINE_FEED);
        int rn = StringUtils.countMatches((String)contentString, (String)CARRIAGE_RETURN_LINE_FEED);
        if (rn >= r - rn || rn >= n - rn) {
            if (rn > 0) {
                this.lineBreak = CARRIAGE_RETURN_LINE_FEED;
            }
            return CARRIAGE_RETURN_LINE_FEED;
        }
        if (n > r) {
            this.lineBreak = LINE_FEED;
            return LINE_FEED;
        }
        this.lineBreak = CARRIAGE_RETURN;
        return CARRIAGE_RETURN;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(OutputFile: sourceProvider=").append(this.sourceProvider).append(",existingTargetStrategy=").append(this.existingTargetStrategy).append(",encoding=").append(this.encoding).append(",filenameOutlet=").append(this.filenameOutlet).append(",contentOutlet=").append(this.contentOutlet).append(",type=").append(this.type).append(")");
        return result.toString();
    }
}

