/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.outlet.java;

import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.outlet.java.StringInputOutlet;
import org.apache.torque.generator.processor.string.Camelbacker;
import org.apache.torque.generator.processor.string.WrapReservedJavaWords;
import org.apache.torque.generator.qname.QualifiedName;

public class CamelbackOutlet
extends StringInputOutlet {
    private final Camelbacker camelbacker = new Camelbacker();
    private final WrapReservedJavaWords reservedWordsWrapper = new WrapReservedJavaWords();
    private boolean wrapReservedJavaWords = false;

    public CamelbackOutlet(QualifiedName qualifiedName) {
        super(qualifiedName);
    }

    public void setRemoveWithoutUppercase(String removeWithoutUppercase) {
        this.camelbacker.setRemoveWithoutUppercase(removeWithoutUppercase);
    }

    public void setRemoveWithUppercase(String removeWithUppercase) {
        this.camelbacker.setRemoveWithUppercase(removeWithUppercase);
    }

    public void setDefaultLowerCase(boolean defaultLowerCase) {
        this.camelbacker.setDefaultLowerCase(defaultLowerCase);
    }

    public void setIgnorePartBefore(String ignorePartBefore) {
        this.camelbacker.setIgnorePartBefore(ignorePartBefore);
    }

    public void setIgnorePartAfter(String ignorePartAfter) {
        this.camelbacker.setIgnorePartBefore(ignorePartAfter);
    }

    public void setFirstCharUppercase(boolean firstCharUppercase) {
        this.camelbacker.setFirstCharUppercase(firstCharUppercase);
    }

    public void setWrapReservedJavaWords(boolean wrapReservedJavaWords) {
        this.wrapReservedJavaWords = wrapReservedJavaWords;
    }

    public void setReservedJavaWordsPrefix(String prefix) {
        this.reservedWordsWrapper.setPrependWhenReserved(prefix);
    }

    public void setReservedJavaWordsSuffix(String suffix) {
        this.reservedWordsWrapper.setAppendWhenReserved(suffix);
    }

    public OutletResult execute(ControllerState controllerState) throws GeneratorException {
        String classnameInput = this.getInput(controllerState);
        String result = this.camelbacker.process(classnameInput);
        if (this.wrapReservedJavaWords) {
            result = this.reservedWordsWrapper.process(result);
        }
        return new OutletResult(result);
    }
}

