/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.DirectAuxHashMap;
import org.apache.datasketches.hll.DirectCouponList;
import org.apache.datasketches.hll.HeapAuxHashMap;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;

abstract class DirectHllArray
extends AbstractHllArray {
    MemorySegment wseg;
    MemorySegment seg;
    Object segObj;
    final boolean compact;

    private static int checkSegCompactFlag(MemorySegment wseg, int lgConfigK) {
        assert (!PreambleUtil.extractCompactFlag(wseg));
        return lgConfigK;
    }

    DirectHllArray(int lgConfigK, TgtHllType tgtHllType, MemorySegment wseg) {
        super(DirectHllArray.checkSegCompactFlag(wseg, lgConfigK), tgtHllType, CurMode.HLL);
        this.wseg = wseg;
        this.seg = wseg;
        this.segObj = wseg.toArray(ValueLayout.JAVA_BYTE);
        this.compact = PreambleUtil.extractCompactFlag(this.seg);
        PreambleUtil.insertEmptyFlag(wseg, false);
    }

    DirectHllArray(int lgConfigK, TgtHllType tgtHllType, MemorySegment seg, boolean readOnly) {
        super(lgConfigK, tgtHllType, CurMode.HLL);
        this.wseg = null;
        this.seg = readOnly ? seg.asReadOnly() : seg;
        this.segObj = seg.toArray(ValueLayout.JAVA_BYTE);
        this.compact = PreambleUtil.extractCompactFlag(seg);
    }

    final void updateMemorySegment(MemorySegment newWseg) {
        this.wseg = newWseg;
        this.seg = newWseg;
        this.segObj = this.wseg.toArray(ValueLayout.JAVA_BYTE);
    }

    @Override
    void addToHipAccum(double delta) {
        DirectHllArray.checkReadOnly(this.wseg);
        double hipAccum = this.seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)PreambleUtil.HIP_ACCUM_DOUBLE);
        this.wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)PreambleUtil.HIP_ACCUM_DOUBLE, hipAccum + delta);
    }

    @Override
    void decNumAtCurMin() {
        DirectHllArray.checkReadOnly(this.wseg);
        int numAtCurMin = this.seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)PreambleUtil.CUR_MIN_COUNT_INT);
        this.wseg.set(ValueLayout.JAVA_INT_UNALIGNED, (long)PreambleUtil.CUR_MIN_COUNT_INT, --numAtCurMin);
    }

    @Override
    int getCurMin() {
        return PreambleUtil.extractCurMin(this.seg);
    }

    @Override
    CurMode getCurMode() {
        return PreambleUtil.extractCurMode(this.seg);
    }

    @Override
    double getHipAccum() {
        return PreambleUtil.extractHipAccum(this.seg);
    }

    @Override
    double getKxQ0() {
        return PreambleUtil.extractKxQ0(this.seg);
    }

    @Override
    double getKxQ1() {
        return PreambleUtil.extractKxQ1(this.seg);
    }

    @Override
    int getLgConfigK() {
        return PreambleUtil.extractLgK(this.seg);
    }

    @Override
    MemorySegment getMemorySegment() {
        return this.seg;
    }

    @Override
    AuxHashMap getNewAuxHashMap() {
        return new DirectAuxHashMap(this, true);
    }

    @Override
    int getNumAtCurMin() {
        return PreambleUtil.extractNumAtCurMin(this.seg);
    }

    @Override
    TgtHllType getTgtHllType() {
        return PreambleUtil.extractTgtHllType(this.seg);
    }

    @Override
    boolean isCompact() {
        return this.compact;
    }

    @Override
    boolean isEmpty() {
        return PreambleUtil.extractEmptyFlag(this.seg);
    }

    @Override
    boolean hasMemorySegment() {
        return this.seg.scope().isAlive();
    }

    @Override
    boolean isOffHeap() {
        return this.seg.isNative();
    }

    @Override
    boolean isOutOfOrder() {
        return PreambleUtil.extractOooFlag(this.seg);
    }

    @Override
    boolean isSameResource(MemorySegment seg) {
        return MemorySegmentStatus.isSameResource(this.seg, seg);
    }

    @Override
    boolean isRebuildCurMinNumKxQFlag() {
        return PreambleUtil.extractRebuildCurMinNumKxQFlag(this.seg);
    }

    @Override
    void putAuxHashMap(AuxHashMap auxHashMap, boolean compact) {
        if (auxHashMap instanceof HeapAuxHashMap) {
            if (compact) {
                this.auxHashMap = auxHashMap;
            } else {
                int[] auxArr = auxHashMap.getAuxIntArr();
                MemorySegment.copy(auxArr, 0, this.wseg, ValueLayout.JAVA_INT_UNALIGNED, (long)this.auxStart, auxArr.length);
                PreambleUtil.insertLgArr(this.wseg, auxHashMap.getLgAuxArrInts());
                PreambleUtil.insertAuxCount(this.wseg, auxHashMap.getAuxCount());
                this.auxHashMap = new DirectAuxHashMap(this, false);
            }
        } else {
            assert (!compact);
            this.auxHashMap = auxHashMap;
        }
    }

    @Override
    void putCurMin(int curMin) {
        DirectHllArray.checkReadOnly(this.wseg);
        PreambleUtil.insertCurMin(this.wseg, curMin);
    }

    @Override
    void putEmptyFlag(boolean empty) {
        DirectHllArray.checkReadOnly(this.wseg);
        PreambleUtil.insertEmptyFlag(this.wseg, empty);
    }

    @Override
    void putHipAccum(double hipAccum) {
        DirectHllArray.checkReadOnly(this.wseg);
        PreambleUtil.insertHipAccum(this.wseg, hipAccum);
    }

    @Override
    void putKxQ0(double kxq0) {
        DirectHllArray.checkReadOnly(this.wseg);
        PreambleUtil.insertKxQ0(this.wseg, kxq0);
    }

    @Override
    void putKxQ1(double kxq1) {
        DirectHllArray.checkReadOnly(this.wseg);
        PreambleUtil.insertKxQ1(this.wseg, kxq1);
    }

    @Override
    void putNumAtCurMin(int numAtCurMin) {
        DirectHllArray.checkReadOnly(this.wseg);
        PreambleUtil.insertNumAtCurMin(this.wseg, numAtCurMin);
    }

    @Override
    void putOutOfOrder(boolean oooFlag) {
        if (oooFlag) {
            this.putHipAccum(0.0);
        }
        DirectHllArray.checkReadOnly(this.wseg);
        PreambleUtil.insertOooFlag(this.wseg, oooFlag);
    }

    @Override
    void putRebuildCurMinNumKxQFlag(boolean rebuild) {
        DirectHllArray.checkReadOnly(this.wseg);
        PreambleUtil.insertRebuildCurMinNumKxQFlag(this.wseg, rebuild);
    }

    @Override
    byte[] toCompactByteArray() {
        return this.toUpdatableByteArray();
    }

    @Override
    byte[] toUpdatableByteArray() {
        int totBytes = this.getCompactSerializationBytes();
        byte[] byteArr = new byte[totBytes];
        MemorySegment segOut = MemorySegment.ofArray(byteArr);
        MemorySegment.copy(this.seg, 0L, segOut, 0L, totBytes);
        PreambleUtil.insertCompactFlag(segOut, false);
        return byteArr;
    }

    @Override
    HllSketchImpl reset() {
        DirectHllArray.checkReadOnly(this.wseg);
        PreambleUtil.insertEmptyFlag(this.wseg, true);
        int bytes = HllSketch.getMaxUpdatableSerializationBytes(this.lgConfigK, this.tgtHllType);
        Util.clear(this.wseg, 0L, bytes);
        return DirectCouponList.newInstance(this.lgConfigK, this.tgtHllType, this.wseg);
    }

    private static final void checkReadOnly(MemorySegment wseg) {
        if (wseg == null) {
            throw new SketchesArgumentException("Cannot modify a read-only sketch");
        }
    }
}

