/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.tdml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.tdml.BitOrderType;
import org.apache.daffodil.tdml.BitsDocumentPart;
import org.apache.daffodil.tdml.ByteDocumentPart;
import org.apache.daffodil.tdml.DataDocumentPart;
import org.apache.daffodil.tdml.Document$;
import org.apache.daffodil.tdml.DocumentPart;
import org.apache.daffodil.tdml.FileDocumentPart;
import org.apache.daffodil.tdml.LSBFirst$;
import org.apache.daffodil.tdml.MSBFirst$;
import org.apache.daffodil.tdml.TestCase;
import org.apache.daffodil.tdml.TextDocumentPart;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.deriving.Mirror;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction2;
import scala.xml.Atom;
import scala.xml.Comment;
import scala.xml.Comment$;
import scala.xml.Elem;
import scala.xml.Elem$;
import scala.xml.EntityRef;
import scala.xml.EntityRef$;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PCData$;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public class Document
implements Product,
Serializable {
    public static final long OFFSET$10 = LazyVals$.MODULE$.getOffsetStatic(Document.class.getDeclaredField("documentBytes$lzy1"));
    public static final long OFFSET$9 = LazyVals$.MODULE$.getOffsetStatic(Document.class.getDeclaredField("nBits$lzy1"));
    public static final long OFFSET$8 = LazyVals$.MODULE$.getOffsetStatic(Document.class.getDeclaredField("documentBits$lzy1"));
    public static final long OFFSET$7 = LazyVals$.MODULE$.getOffsetStatic(Document.class.getDeclaredField("documentParts$lzy1"));
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(Document.class.getDeclaredField("fileParts$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(Document.class.getDeclaredField("dataDocumentParts$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(Document.class.getDeclaredField("unCheckedDocumentParts$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(Document.class.getDeclaredField("children$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(Document.class.getDeclaredField("documentBitOrder$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Document.class.getDeclaredField("nDocumentParts$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Document.class.getDeclaredField("documentExplicitBitOrder$lzy1"));
    private final NodeSeq d;
    private final TestCase parent;
    private volatile Object documentExplicitBitOrder$lzy1;
    private volatile Object nDocumentParts$lzy1;
    private volatile Object documentBitOrder$lzy1;
    private volatile Object children$lzy1;
    private final List<DocumentPart> actualDocumentPartElementChildren;
    private volatile Object unCheckedDocumentParts$lzy1;
    private volatile Object dataDocumentParts$lzy1;
    private volatile Object fileParts$lzy1;
    private volatile Object documentParts$lzy1;
    private volatile Object documentBits$lzy1;
    private volatile Object nBits$lzy1;
    private volatile Object documentBytes$lzy1;
    private final boolean isDPFile;

    public static Document apply(NodeSeq nodeSeq, TestCase testCase) {
        return Document$.MODULE$.apply(nodeSeq, testCase);
    }

    public static Document fromProduct(Product product) {
        return Document$.MODULE$.fromProduct(product);
    }

    public static Document unapply(Document document) {
        return Document$.MODULE$.unapply(document);
    }

    /*
     * WARNING - void declaration
     */
    public Document(NodeSeq d, TestCase parent) {
        void var3_3;
        boolean res;
        this.d = d;
        this.parent = parent;
        this.actualDocumentPartElementChildren = this.children().toList().flatMap((Function1 & Serializable)child -> {
            Tuple5 tuple5;
            Option option;
            Node node = child;
            if (node == null || (option = Elem$.MODULE$.unapplySeq(node)).isEmpty() || !"documentPart".equals((tuple5 = (Tuple5)option.get())._2()) || ((SeqOps)tuple5._5()).lengthCompare(0) < 0) return package$.MODULE$.Nil();
            scala.collection.immutable.Seq seq = ((scala.collection.immutable.Seq)tuple5._5()).toSeq();
            String string = child.$bslash("@type").toString();
            switch (string == null ? 0 : string.hashCode()) {
                case 3024134: {
                    if (!"bits".equals(string)) throw Assert$.MODULE$.invariantFailed("invalid content type.");
                    DocumentPart documentPart = new BitsDocumentPart((Node)child, this);
                    return (List)new .colon.colon((Object)documentPart, (List)Nil$.MODULE$);
                }
                case 3039496: {
                    if (!"byte".equals(string)) throw Assert$.MODULE$.invariantFailed("invalid content type.");
                    DocumentPart documentPart = new ByteDocumentPart((Node)child, this);
                    return (List)new .colon.colon((Object)documentPart, (List)Nil$.MODULE$);
                }
                case 3143036: {
                    if (!"file".equals(string)) throw Assert$.MODULE$.invariantFailed("invalid content type.");
                    DocumentPart documentPart = new FileDocumentPart((Node)child, this);
                    return (List)new .colon.colon((Object)documentPart, (List)Nil$.MODULE$);
                }
                case 3556653: {
                    if (!"text".equals(string)) throw Assert$.MODULE$.invariantFailed("invalid content type.");
                    DocumentPart documentPart = new TextDocumentPart((Node)child, this);
                    return (List)new .colon.colon((Object)documentPart, (List)Nil$.MODULE$);
                }
                default: {
                    throw Assert$.MODULE$.invariantFailed("invalid content type.");
                }
            }
        });
        if (this.actualDocumentPartElementChildren.nonEmpty()) {
            this.children().foreach((Function1)(JProcedure1 & Serializable)child -> {
                Option option;
                Node node = child;
                if (node != null) {
                    String string;
                    String s;
                    Tuple5 tuple5;
                    Option option2 = Elem$.MODULE$.unapplySeq(node);
                    if (!option2.isEmpty() && "documentPart".equals((tuple5 = (Tuple5)option2.get())._2()) && ((SeqOps)tuple5._5()).lengthCompare(0) >= 0) {
                        scala.collection.immutable.Seq seq = ((scala.collection.immutable.Seq)tuple5._5()).toSeq();
                        return;
                    }
                    Option option3 = Text$.MODULE$.unapply((Object)node);
                    if (!option3.isEmpty() && (s = (string = (String)option3.get())).matches("\\s+")) {
                        return;
                    }
                }
                if (node instanceof Comment) {
                    Comment comment = Comment$.MODULE$.unapply((Comment)node);
                    String string = comment._1();
                    return;
                }
                if (node != null && !(option = PCData$.MODULE$.unapply((Object)node)).isEmpty()) {
                    String string;
                    String s = string = (String)option.get();
                    return;
                }
                if (node instanceof EntityRef) {
                    EntityRef entityRef = EntityRef$.MODULE$.unapply((EntityRef)node);
                    String string = entityRef._1();
                    return;
                }
                if (node instanceof Atom) {
                    return;
                }
                Node x = node;
                throw Assert$.MODULE$.usageError("Illegal TDML data document content '" + x + "'");
            });
        }
        boolean bl = res = this.documentParts().nonEmpty() && this.documentParts().head() instanceof FileDocumentPart;
        if (res && this.documentParts().length() != 1) {
            throw Assert$.MODULE$.usageError2("There can be only one documentPart of type file, and it must be the only documentPart.", "Document.this.documentParts.length.==(1)");
        }
        this.isDPFile = var3_3;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Document)) return false;
        Document document = (Document)object;
        NodeSeq nodeSeq = this.d();
        NodeSeq nodeSeq2 = document.d();
        if (nodeSeq == null) {
            if (nodeSeq2 != null) {
                return false;
            }
        } else if (!nodeSeq.equals(nodeSeq2)) return false;
        TestCase testCase = this.parent();
        TestCase testCase2 = document.parent();
        if (testCase == null) {
            if (testCase2 != null) {
                return false;
            }
        } else if (!testCase.equals(testCase2)) return false;
        if (!document.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Document;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Document";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "d";
        }
        if (1 == n2) {
            return "parent";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public NodeSeq d() {
        return this.d;
    }

    public TestCase parent() {
        return this.parent;
    }

    public Option<Mirror.Singleton> documentExplicitBitOrder() {
        Object object = this.documentExplicitBitOrder$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.documentExplicitBitOrder$lzyINIT1();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object documentExplicitBitOrder$lzyINIT1() {
        while (true) {
            Object object;
            block14: {
                if ((object = this.documentExplicitBitOrder$lzy1) != null) break block14;
                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                Object object2 = null;
                None$ none$ = null;
                try {
                    None$ none$2;
                    block15: {
                        String string = this.d().$bslash("@bitOrder").toString();
                        switch (string == null ? 0 : string.hashCode()) {
                            case -636784460: {
                                if (!"MSBFirst".equals(string)) break;
                                none$2 = Some$.MODULE$.apply((Object)MSBFirst$.MODULE$);
                                break block15;
                            }
                            case 0: {
                                if (!"".equals(string)) break;
                                none$2 = None$.MODULE$;
                                break block15;
                            }
                            case 1915372501: {
                                if (!"LSBFirst".equals(string)) break;
                                none$2 = Some$.MODULE$.apply((Object)LSBFirst$.MODULE$);
                                break block15;
                            }
                        }
                        throw Assert$.MODULE$.invariantFailed("invalid bit order.");
                    }
                    none$ = none$2;
                    object2 = none$ == null ? LazyVals.NullValue$.MODULE$ : none$;
                }
                catch (Throwable throwable) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.documentExplicitBitOrder$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    throw throwable;
                }
                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.documentExplicitBitOrder$lzy1;
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                    waiting.countDown();
                }
                return none$;
            }
            if (!(object instanceof LazyVals.LazyValControlState)) {
                return object;
            }
            if (object == LazyVals.Evaluating$.MODULE$) {
                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                continue;
            }
            if (!(object instanceof LazyVals.Waiting)) {
                return null;
            }
            ((LazyVals.Waiting)object).await();
        }
    }

    private int nDocumentParts() {
        Object object = this.nDocumentParts$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.nDocumentParts$lzyINIT1());
    }

    private Object nDocumentParts$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.nDocumentParts$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger((int)this.dataDocumentParts().length());
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.nDocumentParts$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public BitOrderType documentBitOrder() {
        Object object = this.documentBitOrder$lzy1;
        if (object instanceof BitOrderType) {
            return (BitOrderType)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (BitOrderType)this.documentBitOrder$lzyINIT1();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object documentBitOrder$lzyINIT1() {
        while (true) {
            Object object;
            block16: {
                void var2_5;
                if ((object = this.documentBitOrder$lzy1) != null) break block16;
                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                Object var2_2 = null;
                BitOrderType bitOrderType = null;
                try {
                    Mirror.Singleton singleton;
                    block14: {
                        Option<Mirror.Singleton> option;
                        block18: {
                            block17: {
                                Mirror.Singleton order;
                                option = this.documentExplicitBitOrder();
                                if (!(option instanceof Some)) break block17;
                                singleton = order = (Mirror.Singleton)((Some)option).value();
                                break block14;
                            }
                            if (!None$.MODULE$.equals(option)) break block18;
                            Map groups = (Map)this.dataDocumentParts().groupBy((Function1 & Serializable)_$24 -> _$24.explicitBitOrder()).map((Function1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    Option key = (Option)tuple2._1();
                                    scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)tuple2._2();
                                    return Tuple2$.MODULE$.apply((Object)key, (Object)BoxesRunTime.boxToInteger((int)seq.length()));
                                }
                                throw new MatchError((Object)tuple2);
                            });
                            Option option2 = groups.get((Object)Some$.MODULE$.apply((Object)MSBFirst$.MODULE$));
                            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.nDocumentParts()));
                            if (!(option2 != null ? !option2.equals(some) : some != null)) {
                                singleton = MSBFirst$.MODULE$;
                                break block14;
                            } else {
                                Option option3 = groups.get((Object)Some$.MODULE$.apply((Object)LSBFirst$.MODULE$));
                                Some some2 = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.nDocumentParts()));
                                if (!(option3 != null ? !option3.equals(some2) : some2 != null)) {
                                    singleton = LSBFirst$.MODULE$;
                                    break block14;
                                } else {
                                    Option option4 = groups.get((Object)None$.MODULE$);
                                    Some some3 = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.nDocumentParts()));
                                    if (option4 == null) {
                                        if (some3 != null) {
                                            throw Assert$.MODULE$.usageError("Must specify bitOrder on document element when parts have a mixture of bit orders.");
                                        }
                                    } else if (!option4.equals(some3)) throw Assert$.MODULE$.usageError("Must specify bitOrder on document element when parts have a mixture of bit orders.");
                                    singleton = MSBFirst$.MODULE$;
                                }
                            }
                            break block14;
                        }
                        throw new MatchError(option);
                    }
                    bitOrderType = (BitOrderType)singleton;
                    if (bitOrderType == null) {
                        LazyVals.NullValue$ nullValue$ = LazyVals.NullValue$.MODULE$;
                    } else {
                        BitOrderType bitOrderType2 = bitOrderType;
                    }
                }
                catch (Throwable throwable) {
                    if (LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, var2_2)) throw throwable;
                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.documentBitOrder$lzy1;
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, var2_2);
                    waiting.countDown();
                    throw throwable;
                }
                if (LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, (Object)var2_5)) return bitOrderType;
                LazyVals.Waiting waiting = (LazyVals.Waiting)this.documentBitOrder$lzy1;
                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, (Object)var2_5);
                waiting.countDown();
                return bitOrderType;
            }
            if (!(object instanceof LazyVals.LazyValControlState)) return object;
            if (object == LazyVals.Evaluating$.MODULE$) {
                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                continue;
            }
            if (!(object instanceof LazyVals.Waiting)) return null;
            ((LazyVals.Waiting)object).await();
        }
    }

    private scala.collection.immutable.Seq<Node> children() {
        Object object = this.children$lzy1;
        if (object instanceof scala.collection.immutable.Seq) {
            return (scala.collection.immutable.Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (scala.collection.immutable.Seq)this.children$lzyINIT1();
    }

    private Object children$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.children$lzy1) == null) {
                    scala.collection.immutable.Seq seq;
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    scala.collection.immutable.Seq seq2 = null;
                    try {
                        scala.collection.immutable.Seq seq3;
                        scala.collection.immutable.Seq children;
                        scala.collection.immutable.Seq seq4;
                        Tuple5 tuple5;
                        Option option;
                        Node node;
                        SeqOps seqOps;
                        NodeSeq nodeSeq = this.d();
                        if (nodeSeq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)nodeSeq), 1) != 0 || (node = (Node)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) == null || (option = Elem$.MODULE$.unapplySeq(node)).isEmpty() || !"document".equals((tuple5 = (Tuple5)option.get())._2()) || (seq4 = (scala.collection.immutable.Seq)tuple5._5()).lengthCompare(0) < 0) {
                            NodeSeq x = nodeSeq;
                            throw Assert$.MODULE$.invariantFailed("Expected <document>, found " + x);
                        }
                        seq = children = (seq3 = seq4.toSeq());
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.children$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    seq2 = seq;
                    object2 = seq2 == null ? LazyVals.NullValue$.MODULE$ : seq2;
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.children$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return seq2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private scala.collection.immutable.Seq<DocumentPart> unCheckedDocumentParts() {
        Object object = this.unCheckedDocumentParts$lzy1;
        if (object instanceof scala.collection.immutable.Seq) {
            return (scala.collection.immutable.Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (scala.collection.immutable.Seq)this.unCheckedDocumentParts$lzyINIT1();
    }

    private Object unCheckedDocumentParts$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.unCheckedDocumentParts$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    List list = null;
                    List list2 = null;
                    try {
                        List udp;
                        List list3;
                        if (this.actualDocumentPartElementChildren.nonEmpty()) {
                            list3 = this.actualDocumentPartElementChildren;
                        } else {
                            Null$ $md = Null$.MODULE$;
                            $md = new UnprefixedAttribute("type", (Seq)new Text("text"), (MetaData)$md);
                            NodeBuffer $buf = new NodeBuffer();
                            $buf.$amp$plus(this.children());
                            list3 = (List)new .colon.colon((Object)new TextDocumentPart((Node)new Elem(null, "documentPart", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)), this), (List)Nil$.MODULE$);
                        }
                        list2 = udp = list3;
                        list = list2 == null ? LazyVals.NullValue$.MODULE$ : list2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, list)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.unCheckedDocumentParts$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, list);
                            waiting.countDown();
                        }
                    }
                    return list2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private scala.collection.immutable.Seq<DataDocumentPart> dataDocumentParts() {
        Object object = this.dataDocumentParts$lzy1;
        if (object instanceof scala.collection.immutable.Seq) {
            return (scala.collection.immutable.Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (scala.collection.immutable.Seq)this.dataDocumentParts$lzyINIT1();
    }

    private Object dataDocumentParts$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.dataDocumentParts$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    scala.collection.immutable.Seq seq = null;
                    try {
                        scala.collection.immutable.Seq dps;
                        seq = dps = (scala.collection.immutable.Seq)this.unCheckedDocumentParts().collect((PartialFunction)new Serializable(){

                            public final boolean isDefinedAt(DocumentPart x) {
                                DocumentPart documentPart = x;
                                if (documentPart instanceof DataDocumentPart) {
                                    DataDocumentPart dp = (DataDocumentPart)documentPart;
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(DocumentPart x, Function1 function1) {
                                DocumentPart documentPart = x;
                                if (documentPart instanceof DataDocumentPart) {
                                    DataDocumentPart dp = (DataDocumentPart)documentPart;
                                    return dp;
                                }
                                return function1.apply((Object)x);
                            }
                        });
                        object2 = seq == null ? LazyVals.NullValue$.MODULE$ : seq;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dataDocumentParts$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return seq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private scala.collection.immutable.Seq<FileDocumentPart> fileParts() {
        Object object = this.fileParts$lzy1;
        if (object instanceof scala.collection.immutable.Seq) {
            return (scala.collection.immutable.Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (scala.collection.immutable.Seq)this.fileParts$lzyINIT1();
    }

    private Object fileParts$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.fileParts$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    scala.collection.immutable.Seq seq = null;
                    try {
                        scala.collection.immutable.Seq fps = (scala.collection.immutable.Seq)this.unCheckedDocumentParts().collect((PartialFunction)new Serializable(){

                            public final boolean isDefinedAt(DocumentPart x) {
                                DocumentPart documentPart = x;
                                if (documentPart instanceof FileDocumentPart) {
                                    FileDocumentPart fp = (FileDocumentPart)documentPart;
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(DocumentPart x, Function1 function1) {
                                DocumentPart documentPart = x;
                                if (documentPart instanceof FileDocumentPart) {
                                    FileDocumentPart fp = (FileDocumentPart)documentPart;
                                    return fp;
                                }
                                return function1.apply((Object)x);
                            }
                        });
                        if (!(fps.isEmpty() || fps.length() == 1 && this.dataDocumentParts().isEmpty())) {
                            throw Assert$.MODULE$.usageError2("There can be only one documentPart of type file, and it must be the only documentPart.", "fps.isEmpty.||(fps.length.==(1).&&(Document.this.dataDocumentParts.isEmpty))");
                        }
                        seq = fps;
                        object2 = seq == null ? LazyVals.NullValue$.MODULE$ : seq;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.fileParts$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return seq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public scala.collection.immutable.Seq<DocumentPart> documentParts() {
        Object object = this.documentParts$lzy1;
        if (object instanceof scala.collection.immutable.Seq) {
            return (scala.collection.immutable.Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (scala.collection.immutable.Seq)this.documentParts$lzyINIT1();
    }

    private Object documentParts$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.documentParts$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    scala.collection.immutable.Seq seq = null;
                    try {
                        this.checkForBadBitOrderTransitions(this.dataDocumentParts());
                        seq = (scala.collection.immutable.Seq)this.dataDocumentParts().$plus$plus(this.fileParts());
                        object2 = seq == null ? LazyVals.NullValue$.MODULE$ : seq;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.documentParts$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return seq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private void checkForBadBitOrderTransitions(scala.collection.immutable.Seq<DataDocumentPart> dps) {
        if (dps.length() <= 1) {
            return;
        }
        scala.collection.immutable.Seq lengths = (scala.collection.immutable.Seq)dps.map((Function1 & Serializable)_$25 -> _$25.lengthInBits());
        scala.collection.immutable.Seq cumulativeDocumentPartLengthsInBits = (scala.collection.immutable.Seq)lengths.scanLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(x$1, x$2) -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x$1, x$2);
            if (sp2 != null) {
                int sum = sp2._1$mcI$sp();
                int num = sp2._2$mcI$sp();
                return sum + num;
            }
            throw new MatchError((Object)sp2);
        });
        scala.collection.immutable.Seq docPartBitOrders = (scala.collection.immutable.Seq)dps.map((Function1 & Serializable)_$26 -> _$26.partBitOrder());
        scala.collection.immutable.Seq transitions = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)docPartBitOrders.zip((IterableOnce)docPartBitOrders.tail())).zip((IterableOnce)cumulativeDocumentPartLengthsInBits.tail())).zip(dps);
        transitions.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22;
            Tuple2 tuple23 = x$1;
            if (tuple23 != null && (tuple22 = (Tuple2)tuple23._1()) != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                BitOrderType bitOrderPrior = (BitOrderType)tuple2._1();
                BitOrderType bitOrderHere = (BitOrderType)tuple2._2();
                int cumulativeLength = BoxesRunTime.unboxToInt((Object)tuple22._2());
                DataDocumentPart docPart = (DataDocumentPart)tuple23._2();
                BitOrderType bitOrderType = bitOrderPrior;
                BitOrderType bitOrderType2 = bitOrderHere;
                if ((bitOrderType == null ? bitOrderType2 != null : !bitOrderType.equals(bitOrderType2)) && cumulativeLength % 8 != 0) {
                    throw Assert$.MODULE$.usageError2("bitOrder can only change on a byte boundary.", "bitOrderPrior.==(bitOrderHere).||(cumulativeLength.%(8).==(0))");
                }
                return;
            }
            throw new MatchError((Object)tuple23);
        });
    }

    public final List<String> documentBits() {
        Object object = this.documentBits$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.documentBits$lzyINIT1();
    }

    private Object documentBits$lzyINIT1() {
        Object object;
        block17: {
            while (true) {
                if ((object = this.documentBits$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Nil$ nil$ = null;
                    try {
                        List allBits;
                        scala.collection.immutable.Seq seq;
                        int nFragBits = (int)this.nBits() % 8;
                        int nAddOnBits = nFragBits == 0 ? 0 : 8 - nFragBits;
                        String addOnBits = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), nAddOnBits);
                        scala.collection.immutable.Seq bitsFromParts = (scala.collection.immutable.Seq)this.dataDocumentParts().map((Function1 & Serializable)_$27 -> _$27.contentAsBits());
                        BitOrderType bitOrderType = this.documentBitOrder();
                        if (MSBFirst$.MODULE$.equals(bitOrderType)) {
                            seq = (scala.collection.immutable.Seq)bitsFromParts.flatten(Predef$.MODULE$.$conforms());
                        } else if (LSBFirst$.MODULE$.equals(bitOrderType)) {
                            scala.collection.immutable.Seq x = (scala.collection.immutable.Seq)bitsFromParts.map((Function1 & Serializable)_$28 -> (scala.collection.immutable.Seq)_$28.map((Function1 & Serializable)_$29 -> StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(_$29))));
                            String rtlBits = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(((IterableOnceOps)x.flatten(Predef$.MODULE$.$conforms())).mkString()));
                            List ltrBits = StringOps$.MODULE$.sliding$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(rtlBits))), 8, 8).map((Function1 & Serializable)_$30 -> StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(_$30))).toList();
                            seq = ltrBits;
                        } else {
                            throw new MatchError((Object)bitOrderType);
                        }
                        scala.collection.immutable.Seq allPartsBits = seq;
                        List list = allBits = StringOps$.MODULE$.sliding$extension(Predef$.MODULE$.augmentString(allPartsBits.mkString()), 8, 8).toList();
                        Nil$ nil$2 = package$.MODULE$.Nil();
                        if (!(list != null ? !list.equals(nil$2) : nil$2 != null)) {
                            v2 = package$.MODULE$.Nil();
                        } else {
                            String string;
                            BitOrderType bitOrderType2 = this.documentBitOrder();
                            if (MSBFirst$.MODULE$.equals(bitOrderType2)) {
                                string = (String)allBits.last() + addOnBits;
                            } else if (LSBFirst$.MODULE$.equals(bitOrderType2)) {
                                string = addOnBits + allBits.last();
                            } else {
                                throw new MatchError((Object)bitOrderType2);
                            }
                            String lastByte = string;
                            List res = (List)((SeqOps)allBits.dropRight(1)).$colon$plus((Object)lastByte);
                            v2 = nil$ = res;
                        }
                        object2 = nil$ == null ? LazyVals.NullValue$.MODULE$ : nil$;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.documentBits$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.documentBits$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return nil$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block17;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final long nBits() {
        Object object = this.nBits$lzy1;
        if (object instanceof Long) {
            return BoxesRunTime.unboxToLong((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToLong(null);
        }
        return BoxesRunTime.unboxToLong((Object)this.nBits$lzyINIT1());
    }

    private Object nBits$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.nBits$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$9, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Long l = null;
                    try {
                        l = BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.documentParts().map((Function1 & Serializable)_$31 -> _$31.nBits())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                        object2 = l == null ? LazyVals.NullValue$.MODULE$ : l;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$9, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.nBits$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$9, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return l;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$9, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final byte[] documentBytes() {
        Object object = this.documentBytes$lzy1;
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (byte[])this.documentBytes$lzyINIT1();
    }

    private Object documentBytes$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.documentBytes$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    byte[] byArray = null;
                    try {
                        byArray = Misc$.MODULE$.bits2Bytes(this.documentBits());
                        object2 = byArray == null ? LazyVals.NullValue$.MODULE$ : (Object)byArray;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.documentBytes$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return byArray;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$10, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final InputStream data() {
        if (this.isDPFile()) {
            FileDocumentPart dp = (FileDocumentPart)this.documentParts().head();
            InputStream input = dp.fileDataInput();
            return input;
        }
        byte[] bytes = this.documentBytes();
        return new ByteArrayInputStream(bytes);
    }

    public boolean isDPFile() {
        return this.isDPFile;
    }

    public Document copy(NodeSeq d, TestCase parent) {
        return new Document(d, parent);
    }

    public NodeSeq copy$default$1() {
        return this.d();
    }

    public TestCase copy$default$2() {
        return this.parent();
    }

    public NodeSeq _1() {
        return this.d();
    }

    public TestCase _2() {
        return this.parent();
    }
}

