/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.provider.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.provider.impl.BaseObligationHandler;
import org.opensaml.xacml.ctx.provider.impl.ObligationProcessingContext;
import org.opensaml.xacml.ctx.provider.impl.ObligationProcessingException;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.ObligationsType;

public class ObligationService {
    @Nonnull
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    @Nonnull
    private Set<BaseObligationHandler> obligationHandlers = new TreeSet<BaseObligationHandler>(new ObligationHandlerComparator());

    @Nonnull
    @Unmodifiable
    @Live
    public Set<BaseObligationHandler> getObligationHandlers() {
        return Collections.unmodifiableSet(this.obligationHandlers);
    }

    public void addObligationhandler(@Nonnull BaseObligationHandler handler) {
        Constraint.isNotNull((Object)handler, (String)"Handler cannot be null");
        ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.obligationHandlers.add(handler);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void addObligationhandler(@Nonnull Collection<BaseObligationHandler> handlers) {
        Constraint.isNotNull(handlers, (String)"Handlers cannot be null");
        if (handlers.isEmpty()) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.obligationHandlers.addAll(handlers);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void removeObligationHandler(@Nonnull BaseObligationHandler handler) {
        Constraint.isNotNull((Object)handler, (String)"Handler cannot be null");
        ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.obligationHandlers.remove(handler);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processObligations(@Nonnull ObligationProcessingContext context) throws ObligationProcessingException {
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            Iterator<BaseObligationHandler> handlerItr = this.obligationHandlers.iterator();
            Map<String, ObligationType> effectiveObligations = this.preprocessObligations(context);
            while (handlerItr.hasNext()) {
                BaseObligationHandler handler = handlerItr.next();
                if (!effectiveObligations.containsKey(handler.getObligationId())) continue;
                handler.evaluateObligation(context, effectiveObligations.get(handler.getObligationId()));
            }
        }
        finally {
            readLock.unlock();
        }
    }

    @Nonnull
    protected Map<String, ObligationType> preprocessObligations(@Nonnull ObligationProcessingContext context) {
        HashMap<String, ObligationType> effectiveObligations = new HashMap<String, ObligationType>();
        ObligationsType obligations = context.getAuthorizationDecisionResult().getObligations();
        if (obligations == null || obligations.getObligations() == null) {
            return effectiveObligations;
        }
        EffectType activeEffect = context.getAuthorizationDecisionResult().getDecision().getDecision() == DecisionType.DECISION.Permit ? EffectType.Permit : EffectType.Deny;
        for (ObligationType obligation : obligations.getObligations()) {
            if (obligation == null || obligation.getFulfillOn() != activeEffect) continue;
            effectiveObligations.put(obligation.getObligationId(), obligation);
        }
        return effectiveObligations;
    }

    private class ObligationHandlerComparator
    implements Comparator<BaseObligationHandler> {
        private ObligationHandlerComparator() {
        }

        @Override
        public int compare(BaseObligationHandler o1, BaseObligationHandler o2) {
            if (o1.getHandlerPrecedence() == o2.getHandlerPrecedence()) {
                return o1.getObligationId().compareTo(o2.getObligationId());
            }
            if (o1.getHandlerPrecedence() < o2.getHandlerPrecedence()) {
                return -1;
            }
            return 1;
        }
    }
}

