/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.ConfigurationException;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSExchangeSender;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSMessageUtils;
import org.apache.cxf.transport.jms.MessageStreamUtil;
import org.apache.cxf.transport.jms.util.JMSSender;
import org.apache.cxf.transport.jms.util.JMSUtil;
import org.apache.cxf.transport.jms.util.ResourceCloser;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;

class BackChannelConduit
extends AbstractConduit
implements JMSExchangeSender {
    private static final Logger LOG = LogUtils.getL7dLogger(BackChannelConduit.class);
    private JMSConfiguration jmsConfig;
    private org.apache.cxf.message.Message inMessage;
    private Connection persistentConnection;

    BackChannelConduit(org.apache.cxf.message.Message inMessage, JMSConfiguration jmsConfig, Connection connection) {
        super(EndpointReferenceUtils.getAnonymousEndpointReference());
        this.inMessage = inMessage;
        this.jmsConfig = jmsConfig;
        this.persistentConnection = connection;
    }

    BackChannelConduit(org.apache.cxf.message.Message inMessage, JMSConfiguration jmsConfig) {
        this(inMessage, jmsConfig, null);
    }

    public void close(org.apache.cxf.message.Message msg) throws IOException {
        MessageStreamUtil.closeStreams(msg);
        super.close(msg);
    }

    public void setMessageObserver(MessageObserver observer) {
    }

    public void prepare(org.apache.cxf.message.Message message) throws IOException {
        Message jmsMessage = (Message)this.inMessage.get((Object)"org.apache.cxf.jms.request.message");
        message.put((Object)"org.apache.cxf.jms.request.message", (Object)jmsMessage);
        if (!message.containsKey((Object)"org.apache.cxf.jms.server.response.headers") && this.inMessage.containsKey((Object)"org.apache.cxf.jms.server.response.headers")) {
            message.put((Object)"org.apache.cxf.jms.server.response.headers", this.inMessage.get((Object)"org.apache.cxf.jms.server.response.headers"));
        }
        Exchange exchange = this.inMessage.getExchange();
        exchange.setOutMessage(message);
        boolean isTextMessage = jmsMessage instanceof TextMessage && !JMSMessageUtils.isMtomEnabled(message);
        MessageStreamUtil.prepareStream(message, isTextMessage, this);
    }

    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void sendExchange(Exchange exchange, Object replyObj) {
        if (exchange.isOneWay()) {
            return;
        }
        org.apache.cxf.message.Message outMessage = exchange.getOutMessage();
        try (ResourceCloser closer = new ResourceCloser();){
            this.send(outMessage, replyObj, closer);
        }
        catch (JMSException ex) {
            throw JMSUtil.convertJmsException(ex);
        }
    }

    private void send(org.apache.cxf.message.Message outMessage, Object replyObj, ResourceCloser closer) throws JMSException {
        Connection connection = this.persistentConnection == null ? closer.register(JMSFactory.createConnection(this.jmsConfig)) : this.persistentConnection;
        Session session = closer.register(connection.createSession(false, 1));
        JMSMessageHeadersType outProps = (JMSMessageHeadersType)outMessage.get((Object)"org.apache.cxf.jms.server.response.headers");
        JMSMessageHeadersType inProps = (JMSMessageHeadersType)this.inMessage.get((Object)"org.apache.cxf.jms.server.request.headers");
        BackChannelConduit.initResponseMessageProperties(outProps, inProps);
        Message request = (Message)this.inMessage.get((Object)"org.apache.cxf.jms.request.message");
        if (this.isTimedOut(request)) {
            return;
        }
        Destination replyTo = this.getReplyToDestination(session, this.inMessage);
        if (replyTo == null) {
            throw new RuntimeException("No replyTo destination set");
        }
        String msgType = this.getMessageType(outMessage, request);
        String correlationId = this.determineCorrelationID(request);
        Message reply = JMSMessageUtils.asJMSMessage(this.jmsConfig, outMessage, replyObj, msgType, session, correlationId, "org.apache.cxf.jms.server.response.headers");
        JMSSender sender = JMSFactory.createJmsSender(this.jmsConfig, outProps);
        LOG.log(Level.FINE, "server sending reply: ", reply);
        sender.sendMessage(session, replyTo, reply);
    }

    private String getMessageType(org.apache.cxf.message.Message outMessage, Message request) {
        String msgType = JMSMessageUtils.isMtomEnabled(outMessage) && !this.jmsConfig.getMessageType().equals("text") ? this.jmsConfig.getMessageType() : JMSMessageUtils.getMessageType(request);
        if ("text".equals(msgType) && JMSMessageUtils.isMtomEnabled(outMessage)) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INVALID_MESSAGE_TYPE", LOG, new Object[0]);
            throw new ConfigurationException(msg);
        }
        return msgType;
    }

    public static void initResponseMessageProperties(JMSMessageHeadersType messageProperties, JMSMessageHeadersType inMessageProperties) {
        messageProperties.setJMSDeliveryMode(inMessageProperties.getJMSDeliveryMode());
        messageProperties.setJMSPriority(inMessageProperties.getJMSPriority());
        messageProperties.setSOAPJMSRequestURI(inMessageProperties.getSOAPJMSRequestURI());
        messageProperties.setSOAPJMSSOAPAction(inMessageProperties.getSOAPJMSSOAPAction());
        messageProperties.setSOAPJMSBindingVersion("1.0");
    }

    private boolean isTimedOut(Message request) throws JMSException {
        if (request.getJMSExpiration() > 0L) {
            ZonedDateTime dateTime = ZonedDateTime.now(ZoneOffset.UTC);
            long timeToLive = request.getJMSExpiration() - dateTime.toInstant().toEpochMilli();
            if (timeToLive < 0L) {
                this.getLogger().log(Level.INFO, "Message time to live is already expired skipping response.");
                return true;
            }
        }
        return false;
    }

    private Destination getReplyToDestination(Session session, org.apache.cxf.message.Message inMessage2) throws JMSException {
        Message message = (Message)inMessage2.get((Object)"org.apache.cxf.jms.request.message");
        String replyToName = (String)inMessage2.get((Object)"org.apache.cxf.jms.server.replyto");
        if (replyToName != null) {
            return this.jmsConfig.getReplyDestination(session, replyToName);
        }
        if (message.getJMSReplyTo() != null) {
            return message.getJMSReplyTo();
        }
        return this.jmsConfig.getReplyDestination(session);
    }

    public String determineCorrelationID(Message request) throws JMSException {
        return StringUtils.isEmpty((String)request.getJMSCorrelationID()) ? request.getJMSMessageID() : request.getJMSCorrelationID();
    }
}

