/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.statistics.derived.histogram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ehcache.shadow.org.terracotta.statistics.derived.histogram.BarSplittingBiasedHistogram;
import org.ehcache.shadow.org.terracotta.statistics.derived.histogram.Histogram;
import org.ehcache.shadow.org.terracotta.statistics.derived.histogram.ImmutableBucket;
import org.ehcache.shadow.org.terracotta.statistics.derived.histogram.Striped;

public class StripedHistogram
extends Striped<BarSplittingBiasedHistogram>
implements Histogram {
    public StripedHistogram(double maxCoefficient, double phi, int expansionFactor, int bucketCount, double barEpsilon, long window) {
        super(() -> new BarSplittingBiasedHistogram(maxCoefficient, phi, expansionFactor, bucketCount, barEpsilon, window));
    }

    public StripedHistogram(int bucketCount, long window) {
        super(() -> new BarSplittingBiasedHistogram(bucketCount, window));
    }

    public StripedHistogram(double phi, int bucketCount, long window) {
        super(() -> new BarSplittingBiasedHistogram(phi, bucketCount, window));
    }

    @Override
    public List<Histogram.Bucket> getBuckets() {
        List bars = this.stream().flatMap(h -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).sorted(Comparator.comparingDouble(triple -> triple[0])).collect(Collectors.toCollection(LinkedList::new));
        StripedHistogram.mergeBars(bars);
        int bucketCount = this.stream().findAny().map(BarSplittingBiasedHistogram::bucketCount).orElseThrow(AssertionError::new);
        double phi = this.stream().findAny().map(BarSplittingBiasedHistogram::phi).orElseThrow(AssertionError::new);
        double alphaPhi = this.stream().findAny().map(BarSplittingBiasedHistogram::alphaPhi).orElseThrow(AssertionError::new);
        ArrayList<Histogram.Bucket> buckets = new ArrayList<Histogram.Bucket>(bucketCount);
        double targetSize = (double)this.size() * alphaPhi;
        Iterator it = bars.iterator();
        double[] b = (double[])it.next();
        double minimum = b[0];
        double count = b[2];
        for (int i = 0; i < bucketCount - 1 && it.hasNext(); ++i) {
            while (count < targetSize && it.hasNext()) {
                b = (double[])it.next();
                count += b[2];
            }
            double surplus = count - targetSize;
            double maximum = BarSplittingBiasedHistogram.nextUpIfEqual(minimum, b[1] - (b[1] - b[0]) * surplus / b[2]);
            buckets.add(new ImmutableBucket(minimum, maximum, targetSize));
            minimum = maximum;
            count = surplus;
            targetSize *= phi;
        }
        while (it.hasNext()) {
            b = (double[])it.next();
            count += b[2];
        }
        buckets.add(new ImmutableBucket(minimum, BarSplittingBiasedHistogram.nextUpIfEqual(minimum, b[1]), count));
        return buckets;
    }

    static void mergeBars(List<double[]> bars) {
        ListIterator<double[]> listIt = bars.listIterator();
        if (listIt.hasNext()) {
            double[] a = listIt.next();
            while (listIt.hasNext()) {
                double[] b = listIt.next();
                if (a[1] > b[0]) {
                    listIt.remove();
                    listIt.previous();
                    listIt.remove();
                    int backtrackTo = listIt.nextIndex();
                    for (double[] f : StripedHistogram.flatten(a, b)) {
                        while (listIt.hasNext()) {
                            double[] next = listIt.next();
                            if (!(f[0] < next[0]) && (f[0] != next[0] || !(f[1] < next[1]))) continue;
                            listIt.previous();
                            break;
                        }
                        listIt.add(f);
                    }
                    while (listIt.nextIndex() != backtrackTo) {
                        listIt.previous();
                    }
                    if (!listIt.hasNext()) break;
                    a = listIt.next();
                    continue;
                }
                a = b;
            }
        }
    }

    private static List<double[]> flatten(double[] a, double[] b) {
        double aDensity = a[2] / (a[1] - a[0]);
        double bDensity = b[2] / (b[1] - b[0]);
        if (a[0] < b[0]) {
            if (a[1] < b[1]) {
                return Arrays.asList({a[0], b[0], (b[0] - a[0]) * aDensity}, {b[0], a[1], (a[1] - b[0]) * (aDensity + bDensity)}, {a[1], b[1], (b[1] - a[1]) * bDensity});
            }
            if (b[1] < a[1]) {
                return Arrays.asList({a[0], b[0], (b[0] - a[0]) * aDensity}, {b[0], b[1], (b[1] - b[0]) * aDensity + b[2]}, {b[1], a[1], (a[1] - b[1]) * aDensity});
            }
            return Arrays.asList({a[0], b[0], aDensity * (b[0] - a[0])}, {b[0], b[1], aDensity * (b[1] - b[0]) + b[2]});
        }
        if (a[0] == b[0]) {
            if (a[1] < b[1]) {
                return Arrays.asList({a[0], a[1], bDensity * (a[1] - a[0]) + a[2]}, {a[1], b[1], bDensity * (b[1] - a[1])});
            }
            if (b[1] < a[1]) {
                return Arrays.asList({b[0], b[1], aDensity * (b[1] - b[0]) + b[2]}, {b[1], a[1], aDensity * (a[1] - b[1])});
            }
            return Arrays.asList(new double[][]{{a[0], a[1], a[2] + b[2]}});
        }
        throw new AssertionError();
    }

    @Override
    public double[] getQuantileBounds(double quantile) {
        if (quantile > 1.0 || quantile < 0.0) {
            throw new IllegalArgumentException("Invalid quantile requested: " + quantile);
        }
        return Stream.of(this.evaluateQuantileFromMin(quantile), this.evaluateQuantileFromMax(quantile)).min(Comparator.comparingDouble(bounds -> bounds[1] - bounds[0])).get();
    }

    private double[] evaluateQuantileFromMax(double quantile) {
        double threshold = (1.0 - quantile) * (double)this.size();
        List barsByMinimum = this.stream().flatMap(h -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).sorted(Comparator.comparingDouble(tuple -> tuple[0])).collect(Collectors.toList());
        List barsByMaximum = this.stream().flatMap(h -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).sorted(Comparator.comparingDouble(tuple -> tuple[0])).collect(Collectors.toList());
        double highCount = 0.0;
        ListIterator upperIt = barsByMaximum.listIterator(barsByMaximum.size());
        while (upperIt.hasPrevious()) {
            double[] upperB = (double[])upperIt.previous();
            if (!((highCount += upperB[1]) >= threshold)) continue;
            double lowCount = 0.0;
            double[] lowerB = null;
            ListIterator lowerIT = barsByMinimum.listIterator(barsByMinimum.size());
            while (lowerIT.hasPrevious() && !((lowCount += (lowerB = (double[])lowerIT.previous())[1]) >= threshold)) {
            }
            return new double[]{lowerB[0], upperB[0]};
        }
        throw new AssertionError();
    }

    private double[] evaluateQuantileFromMin(double quantile) {
        double threshold = quantile * (double)this.size();
        List barsByMinimum = this.stream().flatMap(h -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).sorted(Comparator.comparingDouble(tuple -> tuple[0])).collect(Collectors.toList());
        List barsByMaximum = this.stream().flatMap(h -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).sorted(Comparator.comparingDouble(tuple -> tuple[0])).collect(Collectors.toList());
        double highCount = 0.0;
        ListIterator lowerIt = barsByMinimum.listIterator();
        while (lowerIt.hasNext()) {
            double[] lowerB = (double[])lowerIt.next();
            if (!((highCount += lowerB[1]) >= threshold)) continue;
            double lowCount = 0.0;
            double[] upperB = null;
            ListIterator upperIt = barsByMaximum.listIterator();
            while (upperIt.hasNext() && !((lowCount += (upperB = (double[])upperIt.next())[1]) >= threshold)) {
            }
            return new double[]{lowerB[0], upperB[0]};
        }
        throw new AssertionError();
    }

    @Override
    public long size() {
        return this.stream().mapToLong(Histogram::size).sum();
    }

    @Override
    public void event(double value, long time) {
        this.process(h -> h.event(value, time));
    }

    @Override
    public void expire(long time) {
        this.stream().forEach(h -> h.expire(time));
    }
}

