/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.databinding.jaxb;

import com.sun.tools.xjc.api.ClassNameAllocator;
import org.apache.cxf.tools.util.ClassCollector;

public class ClassNameAllocatorImpl
implements ClassNameAllocator {
    private static final String TYPE_SUFFIX = "_Type";
    private ClassCollector collector;
    private boolean autoResolveConflicts;

    public ClassNameAllocatorImpl(ClassCollector classCollector, boolean autoResolve) {
        this.collector = classCollector;
        this.autoResolveConflicts = autoResolve;
    }

    private boolean isNameCollision(String packageName, String className) {
        return this.collector.containSeiClass(packageName, className);
    }

    public String assignClassName(String packageName, String className) {
        String fullClzName = className;
        if (this.isNameCollision(packageName, className)) {
            fullClzName = className + TYPE_SUFFIX;
        }
        String fullPckClass = packageName + "." + fullClzName;
        if (this.autoResolveConflicts) {
            int cnt = 1;
            while (this.collector.containsTypeIgnoreCase(packageName, className + (cnt == 1 ? "" : Integer.valueOf(cnt)))) {
                ++cnt;
            }
            if (cnt != 1) {
                className = className + cnt;
                fullClzName = fullClzName + cnt;
                fullPckClass = packageName + "." + fullClzName;
            }
        }
        this.collector.addTypesClassName(packageName, className, fullPckClass);
        return fullClzName;
    }
}

