/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.push;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;
import org.icepush.PushContext;

public class SessionViewManager {
    public static void addView(FacesContext context, String id) {
        PushContext pushContext = SessionViewManager.getPushContext(context);
        State state = SessionViewManager.getState(context);
        pushContext.addGroupMember(state.groupName, id);
        Iterator i = state.groups.iterator();
        while (i.hasNext()) {
            pushContext.addGroupMember((String)i.next(), id);
        }
    }

    public static void removeView(FacesContext context, String id) {
        PushContext pushContext = SessionViewManager.getPushContext(context);
        State state = SessionViewManager.getState(context);
        pushContext.removeGroupMember(state.groupName, id);
        Iterator i = state.groups.iterator();
        while (i.hasNext()) {
            pushContext.removeGroupMember((String)i.next(), id);
        }
    }

    public static void startAddingNewViewsToGroup(FacesContext context, String groupName) {
        State state = SessionViewManager.getState(context);
        state.groups.add(groupName);
    }

    public static void stopAddingNewViewsToGroup(FacesContext context, String groupName) {
        State state = SessionViewManager.getState(context);
        state.groups.remove(groupName);
    }

    private static PushContext getPushContext(FacesContext facesContext) {
        return (PushContext)facesContext.getExternalContext().getApplicationMap().get(PushContext.class.getName());
    }

    private static State getState(FacesContext context) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        State state = (State)sessionMap.get(SessionViewManager.class.getName());
        if (state == null) {
            Object session = context.getExternalContext().getSession(true);
            if (session instanceof HttpSession) {
                state = new State(((HttpSession)session).getId());
            } else if (session instanceof PortletSession) {
                state = new State(((PortletSession)session).getId());
            } else {
                throw new RuntimeException("Unknown session object: " + session);
            }
            sessionMap.put(SessionViewManager.class.getName(), state);
        }
        return state;
    }

    private static class State
    implements Serializable {
        private String groupName;
        private HashSet groups = new HashSet();

        private State(String groupName) {
            this.groupName = groupName;
        }
    }
}

