/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference.gbp;

import cc.mallet.grmm.inference.gbp.MessageArray;
import cc.mallet.grmm.inference.gbp.MessageStrategy;
import cc.mallet.grmm.inference.gbp.RegionEdge;
import cc.mallet.grmm.types.DiscreteFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.LogTableFactor;

public abstract class AbstractMessageStrategy
implements MessageStrategy {
    protected MessageArray oldMessages;
    protected MessageArray newMessages;

    @Override
    public void setMessageArray(MessageArray oldMessages, MessageArray newMessages) {
        this.oldMessages = oldMessages;
        this.newMessages = newMessages;
    }

    @Override
    public MessageArray getOldMessages() {
        return this.oldMessages;
    }

    @Override
    public MessageArray getNewMessages() {
        return this.newMessages;
    }

    Factor msgProduct(RegionEdge edge) {
        DiscreteFactor otherMsg;
        LogTableFactor product = new LogTableFactor(edge.from.vars);
        for (RegionEdge otherEdge : edge.neighboringParents) {
            otherMsg = this.oldMessages.getMessage(otherEdge.from, otherEdge.to);
            product.multiplyBy(otherMsg);
        }
        for (RegionEdge otherEdge : edge.loopingMessages) {
            otherMsg = this.newMessages.getMessage(otherEdge.from, otherEdge.to);
            product.divideBy(otherMsg);
        }
        return product;
    }
}

