/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.info;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.pipeline.PipeBitInfoUtil;
import org.apache.ctakes.gui.component.CellRendererLabel;
import org.apache.ctakes.gui.component.CellRendererPanel;
import org.apache.ctakes.gui.pipeline.bit.info.ProductIconFactory;
import org.apache.log4j.Logger;

public final class PipeBitInfoRenderer
implements ListCellRenderer<Object> {
    private static final Logger LOGGER = Logger.getLogger((String)"PipeBitInfoRenderer");
    private static final Color READER_COLOR = Color.GREEN.darker().darker();
    private static final Color ANNOTATOR_COLOR = Color.CYAN.darker().darker();
    private static final Color WRITER_COLOR = Color.BLUE;
    private static final Color SPECIAL_COLOR = Color.MAGENTA.darker();
    private static final LayoutManager EMPTY_LAYOUT = new GridLayout(1, 1);
    private final JPanel _renderer = new CellRendererPanel(new BorderLayout(5, 0));
    private final JPanel _dependencies = new CellRendererPanel(EMPTY_LAYOUT);
    private final JLabel _textLabel = new CellRendererLabel();
    private final JPanel _products = new CellRendererPanel(EMPTY_LAYOUT);

    public PipeBitInfoRenderer() {
        this._dependencies.setBackground(null);
        this._textLabel.setBackground(null);
        this._products.setBackground(null);
        this._renderer.add((Component)this._dependencies, "West");
        this._renderer.add((Component)this._textLabel, "Center");
        this._renderer.add((Component)this._products, "East");
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this._dependencies.removeAll();
        this._products.removeAll();
        if (isSelected) {
            this._renderer.setBackground(list.getSelectionBackground());
            this._textLabel.setForeground(list.getSelectionForeground());
        } else {
            this._renderer.setBackground(list.getBackground());
        }
        if (!PipeBitInfo.class.isInstance(value)) {
            LOGGER.error((Object)(value.getClass().getName() + " is not a PipeBitInfo"));
            this._dependencies.setLayout(EMPTY_LAYOUT);
            this._products.setLayout(EMPTY_LAYOUT);
            this._textLabel.setText("Invalid");
            this._renderer.setBackground(Color.DARK_GRAY);
            this._renderer.setToolTipText("Invalid Information");
            return this._renderer;
        }
        PipeBitInfo info = (PipeBitInfo)value;
        if (PipeBitInfoUtil.isUnknown((PipeBitInfo)info)) {
            Color bg = isSelected ? Color.GRAY : Color.LIGHT_GRAY;
            this._renderer.setBackground(bg);
        }
        if (!isSelected) {
            Color color = PipeBitInfoRenderer.getColor(info.role());
            this._textLabel.setForeground(color);
        }
        this._textLabel.setText(info.name());
        PipeBitInfoRenderer.createTypeIcons(this._dependencies, info.dependencies());
        PipeBitInfoRenderer.createTypeIcons(this._products, info.products());
        return this._renderer;
    }

    private static Color getColor(PipeBitInfo.Role role) {
        switch (role) {
            case READER: {
                return READER_COLOR;
            }
            case ANNOTATOR: {
                return ANNOTATOR_COLOR;
            }
            case WRITER: {
                return WRITER_COLOR;
            }
            case SPECIAL: {
                return SPECIAL_COLOR;
            }
        }
        return Color.GRAY;
    }

    private static void createTypeIcons(JPanel panel, PipeBitInfo.TypeProduct ... types) {
        panel.setLayout(new GridLayout(1, types.length));
        Arrays.stream(types).map(ProductIconFactory.getInstance()::getIcon).filter(Objects::nonNull).map(CellRendererLabel::new).forEach(panel::add);
    }
}

