/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class TokenUtil {
    private TokenUtil() {
    }

    public static List<String> getBsvItems(String line) {
        return TokenUtil.getSeparatedValueItems(line, '|');
    }

    public static List<String> getTildeItems(String line) {
        return TokenUtil.getSeparatedValueItems(line, '~');
    }

    public static List<String> getCsvItems(String line) {
        return TokenUtil.getSeparatedValueItems(line, ',');
    }

    private static List<String> getSeparatedValueItems(String line, char separator) {
        if (line == null || line.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int startIndex = 0;
        int stopIndex = line.indexOf(separator);
        while (stopIndex > 0 && stopIndex < line.length()) {
            tokens.add(line.substring(startIndex, stopIndex));
            startIndex = stopIndex + 1;
            stopIndex = line.indexOf(separator, startIndex);
        }
        if (startIndex < line.length() - 1) {
            tokens.add(line.substring(startIndex));
        } else {
            tokens.add("");
        }
        return tokens;
    }

    public static String createBsvLine(Collection<String> values) {
        if (values == null) {
            return "";
        }
        return TokenUtil.createBsvLine(values.toArray(new String[values.size()]));
    }

    public static String createBsvLine(String ... values) {
        if (values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            sb.append(value).append("|");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String createCsvLine(Collection<String> values) {
        if (values == null) {
            return "";
        }
        return TokenUtil.createCsvLine(values.toArray(new String[values.size()]));
    }

    public static String createCsvLine(String ... values) {
        if (values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            sb.append(value).append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

