/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk.extractors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.temporary.assertion.AssertionCuePhraseAnnotation;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;

public class CueWordTest {
    Logger logger = Logger.getLogger((String)CueWordTest.class.getName());

    public static void main(String[] args) throws UIMAException, IOException {
        CueWordTest t = new CueWordTest();
        t.execute();
    }

    public void execute() throws UIMAException, IOException {
        this.logger.info((Object)"starting");
        AggregateBuilder builder = new AggregateBuilder();
        TypeSystemDescription typeSystemDescription = TypeSystemDescriptionFactory.createTypeSystemDescription();
        String filename = "/work/medfacts/sharp/data/2013-01-11_cue_phrase_feature_test/ON03FP00037D00207__merged.txt.xmi";
        JCas jcas = JCasFactory.createJCas((String)filename, (TypeSystemDescription)typeSystemDescription);
        this.logger.info((Object)"=====");
        Collection tokens = JCasUtil.select((JCas)jcas, BaseToken.class);
        for (BaseToken currentToken : tokens) {
            this.logger.info((Object)String.format("token \"%s\" [%s]", currentToken.getCoveredText(), currentToken.getClass().getName()));
        }
        this.logger.info((Object)"=====");
        Map entityToSentenceMap = JCasUtil.indexCovering((JCas)jcas, IdentifiedAnnotation.class, Sentence.class);
        Map sentenceToCoveredCuePhraseMap = JCasUtil.indexCovered((JCas)jcas, Sentence.class, AssertionCuePhraseAnnotation.class);
        CombinedExtractor1 baseExtractorCuePhraseCategory = new CombinedExtractor1((FeatureExtractor1)new CoveredTextExtractor(), (FeatureExtractor1)new TypePathExtractor(AssertionCuePhraseAnnotation.class, "cuePhrase"), (FeatureExtractor1)new TypePathExtractor(AssertionCuePhraseAnnotation.class, "cuePhraseCategory"), (FeatureExtractor1)new TypePathExtractor(AssertionCuePhraseAnnotation.class, "cuePhraseAssertionFamily"));
        CleartkExtractor cuePhraseInWindowExtractor = new CleartkExtractor(AssertionCuePhraseAnnotation.class, (FeatureExtractor1)baseExtractorCuePhraseCategory, new CleartkExtractor.Context[]{new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(5)}), new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Following(5)})});
        ArrayList<CleartkExtractor> extractorList = new ArrayList<CleartkExtractor>();
        extractorList.add(cuePhraseInWindowExtractor);
        Collection identifiedAnnotations = JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class);
        for (IdentifiedAnnotation current : identifiedAnnotations) {
            if (!(current instanceof EntityMention) && !(current instanceof EventMention)) continue;
            this.logger.info((Object)String.format("identified annotation (event or entity) [%d-%d] \"%s\" [%s]", current.getBegin(), current.getEnd(), current.getCoveredText(), current.getClass().getName()));
            Collection coveringSentences = (Collection)entityToSentenceMap.get(current);
            if (coveringSentences == null || coveringSentences.isEmpty()) {
                this.logger.info((Object)"no covering sentences found!!! continuing with next entity/event...");
                continue;
            }
            this.logger.info((Object)String.format("covering sentence count: %d", coveringSentences.size()));
            Sentence firstCoveringSentence = (Sentence)coveringSentences.iterator().next();
            this.logger.info((Object)String.format("first covering sentence: [%d-%d] \"%s\" (%s)", firstCoveringSentence.getBegin(), firstCoveringSentence.getEnd(), firstCoveringSentence.getCoveredText(), firstCoveringSentence.getClass().getName()));
            List cuePhraseFeatures = cuePhraseInWindowExtractor.extractWithin(jcas, (Annotation)current, (Annotation)firstCoveringSentence);
            if (cuePhraseFeatures == null || cuePhraseFeatures.isEmpty()) continue;
            String featureDebugString = cuePhraseFeatures == null ? "(no cue phrase features)" : cuePhraseFeatures.toString();
            this.logger.info((Object)("### cue phrase features: " + featureDebugString));
        }
        this.logger.info((Object)"=====");
        this.logger.info((Object)"finished");
    }
}

