/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.svmlight.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.cleartk.ml.svmlight.model.Kernel;
import org.cleartk.ml.svmlight.model.LinearKernel;
import org.cleartk.ml.svmlight.model.PolynomialKernel;
import org.cleartk.ml.svmlight.model.RbfKernel;
import org.cleartk.ml.svmlight.model.SigmoidKernel;
import org.cleartk.ml.svmlight.model.SupportVector;
import org.cleartk.ml.svmlight.model.UnsupportedKernelError;
import org.cleartk.ml.util.featurevector.FeatureVector;
import org.cleartk.ml.util.featurevector.InvalidFeatureVectorValueException;
import org.cleartk.ml.util.featurevector.SparseFeatureVector;

public class SvmLightModel {
    SupportVector[] supportVectors;
    double bias;
    Kernel kernel;
    String version;

    public static SvmLightModel fromFile(File modelFile) throws IOException {
        FileInputStream modelStream = new FileInputStream(modelFile);
        SvmLightModel model = SvmLightModel.fromInputStream(modelStream);
        ((InputStream)modelStream).close();
        return model;
    }

    public static SvmLightModel fromInputStream(InputStream modelStream) throws IOException {
        String buffer;
        SvmLightModel model = new SvmLightModel();
        SvmLightReader in = new SvmLightReader(modelStream);
        model.version = buffer = in.readLine();
        int ktype = Integer.valueOf(in.readLine());
        int kpar_degree = Integer.valueOf(in.readLine());
        double kpar_gamma = Double.valueOf(in.readLine());
        double kpar_s = Double.valueOf(in.readLine());
        double kpar_c = Double.valueOf(in.readLine());
        in.readLine();
        switch (ktype) {
            case 0: {
                model.kernel = new LinearKernel();
                break;
            }
            case 1: {
                model.kernel = new PolynomialKernel(kpar_s, kpar_c, kpar_degree);
                break;
            }
            case 2: {
                model.kernel = new RbfKernel(kpar_gamma);
                break;
            }
            case 3: {
                model.kernel = new SigmoidKernel(kpar_s, kpar_c);
                break;
            }
            default: {
                throw new UnsupportedKernelError();
            }
        }
        in.readLine();
        in.readLine();
        int numberOfSupportVectors = Integer.valueOf(in.readLine()) - 1;
        model.bias = Double.valueOf(in.readLine());
        model.supportVectors = new SupportVector[numberOfSupportVectors];
        for (int i = 0; i < numberOfSupportVectors; ++i) {
            model.supportVectors[i] = SvmLightModel.readSV(in);
        }
        try {
            model.compress();
        }
        catch (InvalidFeatureVectorValueException e) {
            throw new IOException(e);
        }
        return model;
    }

    private SvmLightModel() {
    }

    public double evaluate(FeatureVector fv) {
        double result = -this.bias;
        for (SupportVector sv : this.supportVectors) {
            result += sv.alpha_y * this.kernel.evaluate(fv, sv.featureVector);
        }
        return result;
    }

    private static SupportVector readSV(SvmLightReader in) throws IOException {
        String[] fields = in.readLine().split(" ");
        double alpha_y = Double.valueOf(fields[0]);
        SparseFeatureVector fv = new SparseFeatureVector();
        for (int i = 1; i < fields.length; ++i) {
            String[] parts = fields[i].split(":");
            int featureIndex = Integer.valueOf(parts[0]);
            double featureValue = Double.valueOf(parts[1]);
            try {
                fv.set(featureIndex, featureValue);
                continue;
            }
            catch (InvalidFeatureVectorValueException e) {
                throw new IOException(e);
            }
        }
        return new SupportVector(alpha_y, (FeatureVector)fv);
    }

    private void compress() throws InvalidFeatureVectorValueException {
        if (!(this.kernel instanceof LinearKernel)) {
            return;
        }
        SparseFeatureVector newFV = new SparseFeatureVector();
        for (SupportVector sv : this.supportVectors) {
            SparseFeatureVector fv = new SparseFeatureVector(sv.featureVector);
            fv.multiply(sv.alpha_y);
            newFV.add((FeatureVector)fv);
        }
        SupportVector[] newSVs = new SupportVector[]{new SupportVector(1.0, (FeatureVector)newFV)};
        this.supportVectors = newSVs;
    }

    private static class SvmLightReader {
        BufferedReader reader;

        SvmLightReader(InputStream modelStream) {
            this.reader = new BufferedReader(new InputStreamReader(modelStream));
        }

        String readLine() throws IOException {
            String line = this.reader.readLine().trim();
            return line.split("#")[0].trim();
        }
    }
}

