/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.dependency.DEPFeat;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import java.io.BufferedReader;
import java.io.IOException;
import org.kohsuke.args4j.Option;

public class RolesetEvaluate
extends AbstractRun {
    @Option(name="-g", usage="gold-standard file (required)", required=true, metaVar="<filename>")
    private String s_goldFile;
    @Option(name="-s", usage="system-generated file (required)", required=true, metaVar="<filename>")
    private String s_autoFile;
    @Option(name="-gi", usage="column index of extra features in a gold-standard file (required)", required=true, metaVar="<integer>")
    private int i_goldIndex;
    @Option(name="-si", usage="column index of extra features in a system-generated file (required)", required=true, metaVar="<integer>")
    private int i_autoIndex;

    public RolesetEvaluate() {
    }

    public RolesetEvaluate(String[] args) {
        this.initArgs(args);
        this.run(this.s_goldFile, this.s_autoFile, this.i_goldIndex - 1, this.i_autoIndex - 1);
    }

    public void run(String goldFile, String autoFile, int goldIndex, int autoIndex) {
        BufferedReader fGold = UTInput.createBufferedFileReader(goldFile);
        BufferedReader fAuto = UTInput.createBufferedFileReader(autoFile);
        int[] counts = new int[]{0, 0};
        try {
            String line;
            while ((line = fGold.readLine()) != null) {
                String[] gold = line.split("\t");
                String[] auto = fAuto.readLine().split("\t");
                if ((line = line.trim()).isEmpty()) continue;
                DEPFeat gFeats = new DEPFeat(gold[goldIndex]);
                DEPFeat aFeats = new DEPFeat(auto[autoIndex]);
                String gPred = (String)gFeats.get("pb");
                String aPred = (String)aFeats.get("pb");
                if (gPred == null) continue;
                counts[0] = counts[0] + 1;
                if (!gPred.equals(aPred)) continue;
                counts[1] = counts[1] + 1;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.printf("Accuracy: %5.2f (%d/%d)\n", 100.0 * (double)counts[1] / (double)counts[0], counts[1], counts[0]);
    }

    public static void main(String[] args) {
        new RolesetEvaluate(args);
    }
}

