/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.classification.model.StringModel;
import com.googlecode.clearnlp.classification.train.StringTrainSpace;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineSetter;
import com.googlecode.clearnlp.feature.xml.SRLFtrXml;
import com.googlecode.clearnlp.predicate.PredIdentifier;
import com.googlecode.clearnlp.reader.DEPReader;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTFile;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTXml;
import java.io.FileInputStream;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Element;

public class PredTrain
extends AbstractRun {
    @Option(name="-i", usage="the directory containg training files (required)", required=true, metaVar="<directory>")
    protected String s_trainDir;
    @Option(name="-c", usage="the configuration file (required)", required=true, metaVar="<filename>")
    protected String s_configXml;
    @Option(name="-f", usage="the feature file for predicate identification (required)", required=true, metaVar="<filename>")
    protected String s_featureXml;
    @Option(name="-m", usage="the model file (output; required)", required=true, metaVar="<filename>")
    protected String s_modelFile;

    public PredTrain() {
    }

    public PredTrain(String[] args) {
        this.initArgs(args);
        try {
            this.run(this.s_configXml, this.s_featureXml, this.s_trainDir, this.s_modelFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(String configXml, String featureXml, String trainDir, String modelFile) throws Exception {
        Element eConfig = UTXml.getDocumentElement(new FileInputStream(configXml));
        DEPReader reader = (DEPReader)this.getReader((Element)eConfig).o1;
        SRLFtrXml xml = new SRLFtrXml(new FileInputStream(featureXml));
        String[] trainFiles = UTFile.getSortedFileList(trainDir);
        PredIdentifier identifier = this.getTrainedIdentifier(eConfig, reader, xml, trainFiles, -1);
        EngineSetter.setPredIdentifier(modelFile, featureXml, identifier);
    }

    public PredIdentifier getTrainedIdentifier(Element eConfig, DEPReader reader, SRLFtrXml xml, String[] trainFiles, int devId) throws Exception {
        StringTrainSpace space = new StringTrainSpace(false, xml.getLabelCutoff(0), xml.getFeatureCutoff(0));
        PredIdentifier identifier = new PredIdentifier(xml, space);
        int size = trainFiles.length;
        System.out.println("Collecting training instances:");
        for (int i = 0; i < size; ++i) {
            DEPTree tree;
            if (devId == i) continue;
            reader.open(UTInput.createBufferedFileReader(trainFiles[i]));
            while ((tree = reader.next()) != null) {
                identifier.identify(tree);
            }
            System.out.print(".");
            reader.close();
        }
        System.out.println();
        StringModel model = (StringModel)this.getModel(UTXml.getFirstElementByTagName(eConfig, "train"), space, 0);
        return new PredIdentifier(xml, model);
    }

    public static void main(String[] args) {
        new PredTrain(args);
    }
}

