/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.constituent.CTLib;
import com.googlecode.clearnlp.constituent.CTReader;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.io.FileExtFilter;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import java.io.File;
import java.io.PrintStream;
import org.kohsuke.args4j.Option;

public class ECNormalize
extends AbstractRun {
    @Option(name="-i", usage="the input path (input; required)", required=true, metaVar="<filepath>")
    private String s_inputPath;
    @Option(name="-o", usage="the output path (output; required)", required=true, metaVar="<filepath>")
    private String s_outputPath;
    @Option(name="-ie", usage="the input file extension (default: .*)", required=false, metaVar="<regex>")
    private String s_inputExt = ".*";

    public ECNormalize() {
    }

    public ECNormalize(String[] args) {
        this.initArgs(args);
        if (new File(this.s_inputPath).isFile()) {
            this.normalize(this.s_inputPath, this.s_outputPath);
        } else {
            this.normalize(this.s_inputPath, this.s_outputPath, this.s_inputExt);
        }
    }

    public void normalize(String inputPath, String outputPath, String inputExt) {
        File dir = new File(outputPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        inputPath = inputPath + File.separator;
        outputPath = outputPath + File.separator;
        for (String filename : new File(inputPath).list(new FileExtFilter(inputExt))) {
            String inputFile = inputPath + filename;
            String outputFile = outputPath + filename;
            System.out.println(filename);
            this.normalize(inputFile, outputFile);
        }
    }

    public void normalize(String inputFile, String outputFile) {
        CTTree tree;
        CTReader reader = new CTReader(UTInput.createBufferedFileReader(inputFile));
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        while ((tree = reader.nextTree()) != null) {
            CTLib.normalizeIndices(tree);
            fout.println(tree.toString() + "\n");
        }
        reader.close();
        fout.close();
    }

    public static void main(String[] args) {
        new ECNormalize(args);
    }
}

