/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.propbank;

public class PBLoc
implements Comparable<PBLoc> {
    public int terminalId;
    public int height;
    public String type;

    public PBLoc(int terminalId, int height) {
        this.set(terminalId, height, "");
    }

    public PBLoc(int terminalId, int height, String type) {
        this.set(terminalId, height, type);
    }

    public PBLoc(String str, String type) {
        String[] loc = str.split(":");
        try {
            this.terminalId = Integer.parseInt(loc[0]);
            this.height = Integer.parseInt(loc[1]);
            this.type = type;
        }
        catch (NumberFormatException e) {
            System.err.println("Error: illegal format - " + str);
            System.exit(1);
        }
    }

    public PBLoc(PBLoc loc, String type) {
        this.set(loc, type);
    }

    public void set(int terminalId, int height) {
        this.terminalId = terminalId;
        this.height = height;
    }

    public void set(int terminalId, int height, String type) {
        this.terminalId = terminalId;
        this.height = height;
        this.type = type;
    }

    public void set(PBLoc loc, String type) {
        this.terminalId = loc.terminalId;
        this.height = loc.height;
        this.type = type;
    }

    public boolean isType(String type) {
        return this.type.equals(type);
    }

    public boolean equals(int terminalId, int height) {
        return this.terminalId == terminalId && this.height == height;
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append(this.type);
        build.append(this.terminalId);
        build.append(":");
        build.append(this.height);
        return build.toString();
    }

    @Override
    public int compareTo(PBLoc loc) {
        if (this.terminalId == loc.terminalId) {
            return this.height - loc.height;
        }
        return this.terminalId - loc.terminalId;
    }
}

