/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.conversion;

import com.googlecode.clearnlp.constituent.CTNode;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.conversion.C2DInfo;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.headrule.HeadRule;
import com.googlecode.clearnlp.headrule.HeadRuleMap;

public abstract class AbstractC2DConverter {
    protected HeadRuleMap m_headrules;

    public AbstractC2DConverter(HeadRuleMap headrules) {
        this.m_headrules = headrules;
    }

    protected void setHeads(CTNode curr) {
        if (!curr.isPhrase()) {
            curr.c2d = new C2DInfo(curr);
            return;
        }
        for (CTNode child : curr.getChildren()) {
            this.setHeads(child);
        }
        if (curr.isPTag("TOP")) {
            return;
        }
        if (curr.getChildrenSize() == 1) {
            curr.c2d = new C2DInfo(curr.getChild(0));
            return;
        }
        HeadRule rule = (HeadRule)this.m_headrules.get(curr.pTag);
        if (rule == null) {
            System.err.println("Error: headrules not found for \"" + curr.pTag + "\"");
            rule = (HeadRule)this.m_headrules.get("X");
        }
        this.setHeadsAux(rule, curr);
    }

    protected abstract void setHeadsAux(HeadRule var1, CTNode var2);

    public abstract DEPTree toDEPTree(CTTree var1);
}

