/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.chunking;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.chunking.Chunking;

public abstract class Chunking_ImplBase<SUB_CHUNK_TYPE extends Annotation, CHUNK_TYPE extends Annotation>
implements Chunking<String, SUB_CHUNK_TYPE, CHUNK_TYPE> {
    protected Class<? extends CHUNK_TYPE> chunkClass;
    protected Class<? extends SUB_CHUNK_TYPE> subChunkClass;
    protected String featureFullName;

    public Chunking_ImplBase(Class<? extends SUB_CHUNK_TYPE> subChunkClass, Class<? extends CHUNK_TYPE> chunkClass, String featureName) {
        this.subChunkClass = subChunkClass;
        this.chunkClass = chunkClass;
        this.featureFullName = featureName == null ? null : chunkClass.getCanonicalName() + ":" + featureName;
    }

    protected Feature getFeature(JCas jCas) {
        String name = this.featureFullName;
        return name == null ? null : jCas.getTypeSystem().getFeatureByFullName(name);
    }

    protected String getOutcomeSuffix(CHUNK_TYPE chunk, Feature feature) {
        return feature == null ? "" : "-" + chunk.getFeatureValueAsString(feature);
    }

    protected abstract Map<SUB_CHUNK_TYPE, String> getSubChunkToOutcomeMap(JCas var1, List<SUB_CHUNK_TYPE> var2, List<CHUNK_TYPE> var3);

    @Override
    public List<String> createOutcomes(JCas jCas, List<SUB_CHUNK_TYPE> subChunks, List<CHUNK_TYPE> chunks) throws AnalysisEngineProcessException {
        Map<SUB_CHUNK_TYPE, String> subChunkToOutcome = this.getSubChunkToOutcomeMap(jCas, subChunks, chunks);
        ArrayList<String> outcomes = new ArrayList<String>();
        for (Annotation subChunk : subChunks) {
            String outcome = subChunkToOutcome.get(subChunk);
            if (outcome == null) {
                outcome = "O";
            }
            outcomes.add(outcome);
        }
        return outcomes;
    }

    protected abstract boolean isEndOfChunk(char var1, String var2, char var3, String var4);

    @Override
    public List<CHUNK_TYPE> createChunks(JCas jCas, List<SUB_CHUNK_TYPE> subChunks, List<String> outcomes) throws AnalysisEngineProcessException {
        int nOutcomes;
        int nSubChunks = subChunks.size();
        if (nSubChunks != (nOutcomes = outcomes.size())) {
            String message = "expected the same number of sub-chunks (%d) as outcome s(%d)";
            throw new IllegalArgumentException(String.format(message, nSubChunks, nOutcomes));
        }
        Feature feature = this.featureFullName == null ? null : jCas.getTypeSystem().getFeatureByFullName(this.featureFullName);
        ArrayList<ChunkOutcome> chunkOutcomes = new ArrayList<ChunkOutcome>();
        for (String outcome : outcomes) {
            chunkOutcomes.add(new ChunkOutcome(outcome));
        }
        chunkOutcomes.add(new ChunkOutcome("O"));
        ArrayList<Annotation> chunks = new ArrayList<Annotation>();
        for (int i = 0; i < outcomes.size(); ++i) {
            Annotation chunk;
            Constructor<CHUNK_TYPE> constructor;
            ChunkOutcome outcome = (ChunkOutcome)chunkOutcomes.get(i);
            if (outcome.prefix == 'O') continue;
            int begin = i;
            int end = i;
            while (true) {
                ChunkOutcome curr = (ChunkOutcome)chunkOutcomes.get(end);
                ChunkOutcome next = (ChunkOutcome)chunkOutcomes.get(end + 1);
                if (this.isEndOfChunk(curr.prefix, curr.label, next.prefix, next.label)) break;
                ++end;
            }
            i = end;
            begin = ((Annotation)subChunks.get(begin)).getBegin();
            end = ((Annotation)subChunks.get(end)).getEnd();
            try {
                constructor = this.chunkClass.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            try {
                chunk = (Annotation)constructor.newInstance(jCas, begin, end);
            }
            catch (InstantiationException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            if (this.featureFullName != null) {
                chunk.setFeatureValueFromString(feature, outcome.label);
            }
            chunk.addToIndexes();
            chunks.add(chunk);
        }
        return chunks;
    }

    private static class ChunkOutcome {
        public char prefix;
        public String label;

        public ChunkOutcome(String outcome) {
            this.prefix = outcome.charAt(0);
            this.label = outcome.length() < 2 ? "" : outcome.substring(2);
        }
    }
}

