/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.chunking;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.chunking.Chunking_ImplBase;

public class BiesoChunking<SUB_CHUNK_TYPE extends Annotation, CHUNK_TYPE extends Annotation>
extends Chunking_ImplBase<SUB_CHUNK_TYPE, CHUNK_TYPE> {
    public BiesoChunking(Class<? extends SUB_CHUNK_TYPE> subChunkClass, Class<? extends CHUNK_TYPE> chunkClass) {
        super(subChunkClass, chunkClass, null);
    }

    public BiesoChunking(Class<? extends SUB_CHUNK_TYPE> subChunkClass, Class<? extends CHUNK_TYPE> chunkClass, String featureName) {
        super(subChunkClass, chunkClass, featureName);
    }

    @Override
    protected Map<SUB_CHUNK_TYPE, String> getSubChunkToOutcomeMap(JCas jCas, List<SUB_CHUNK_TYPE> chunkComponents, List<CHUNK_TYPE> chunks) {
        Feature feature = this.getFeature(jCas);
        HashMap<Object, String> subChunkToOutcome = new HashMap<Object, String>();
        for (Annotation chunk : chunks) {
            String suffix = this.getOutcomeSuffix(chunk, feature);
            List subChunks = JCasUtil.selectCovered((Class)this.subChunkClass, (AnnotationFS)chunk);
            int nSubChunks = subChunks.size();
            if (nSubChunks == 1) {
                subChunkToOutcome.put(subChunks.get(0), "S" + suffix);
                continue;
            }
            for (int i = 0; i < nSubChunks; ++i) {
                Annotation subChunk = (Annotation)subChunks.get(i);
                if (i == 0) {
                    subChunkToOutcome.put(subChunk, "B" + suffix);
                    continue;
                }
                if (i == nSubChunks - 1) {
                    subChunkToOutcome.put(subChunk, "E" + suffix);
                    continue;
                }
                subChunkToOutcome.put(subChunk, "I" + suffix);
            }
        }
        return subChunkToOutcome;
    }

    @Override
    protected boolean isEndOfChunk(char currPrefix, String currLabel, char nextPrefix, String nextLabel) {
        return currPrefix == 'E' || currPrefix == 'S' || nextPrefix == 'O' || nextPrefix == 'B' || !nextLabel.equals(currLabel);
    }
}

