/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.component.AttributeConstants;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import org.icefaces.impl.util.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextRenderer
extends DomBasicInputRenderer {
    private static final String[] output_passThruAttributes = AttributeConstants.getAttributes(14);
    private static final String[] input_passThruAttributes = new String[]{"accesskey", "alt", "dir", "lang", "maxlength", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onselect", "size", "style", "tabindex", "title"};

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) {
        TextRenderer.validateParameters(facesContext, uiComponent, null);
    }

    protected void renderEnd(FacesContext facesContext, UIComponent uiComponent, String currentValue) throws IOException {
        TextRenderer.validateParameters(facesContext, uiComponent, null);
        if (this.isRenderingAsInput(uiComponent)) {
            this.renderUIInput(facesContext, uiComponent, currentValue);
        } else if (this.isRenderingAsOutput(uiComponent)) {
            this.renderUIOutput(facesContext, uiComponent, currentValue);
        }
    }

    protected boolean isRenderingAsInput(UIComponent uiComponent) {
        return uiComponent instanceof UIInput;
    }

    protected boolean isRenderingAsOutput(UIComponent uiComponent) {
        return uiComponent instanceof UIOutput;
    }

    private void renderUIOutput(FacesContext facesContext, UIComponent uiComponent, String currentValue) throws IOException {
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        boolean requiresContainingSpan = this.requiresContainingSpan(uiComponent);
        if (requiresContainingSpan) {
            this.renderContainingSpan(facesContext, uiComponent, domContext);
        } else {
            this.renderTextNode(domContext);
        }
        if (currentValue == null) {
            Text textNode = null;
            textNode = requiresContainingSpan ? (Text)domContext.getRootNode().getFirstChild() : (Text)domContext.getRootNode();
            if (textNode != null) {
                textNode.setData("");
            }
        } else {
            this.renderCurrentValue(uiComponent, currentValue, domContext, requiresContainingSpan);
        }
    }

    private void renderTextNode(DOMContext domContext) {
        if (!domContext.isInitialized()) {
            Text root = domContext.createTextNode("");
            domContext.setRootNode(root);
        } else if (!(domContext.getRootNode() instanceof Text)) {
            domContext.getRootNode().getParentNode().removeChild(domContext.getRootNode());
            domContext.setRootNode(domContext.createTextNode(""));
        }
    }

    private void renderContainingSpan(FacesContext facesContext, UIComponent uiComponent, DOMContext domContext) {
        if (!domContext.isInitialized()) {
            Element root = domContext.createElement("span");
            domContext.setRootNode(root);
        } else if (!(domContext.getRootNode() instanceof Element)) {
            domContext.getRootNode().getParentNode().removeChild(domContext.getRootNode());
            domContext.setRootNode(domContext.createElement("span"));
        }
        Element rootSpan = (Element)domContext.getRootNode();
        TextRenderer.setRootElementId(facesContext, rootSpan, uiComponent);
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            rootSpan.setAttribute("class", styleClass);
        }
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, output_passThruAttributes);
    }

    private void renderCurrentValue(UIComponent uiComponent, String currentValue, DOMContext domContext, boolean requiresContainingSpan) {
        boolean valueTextRequiresEscape = DOMUtils.escapeIsRequired((UIComponent)uiComponent);
        if (valueTextRequiresEscape) {
            currentValue = DOMUtils.escapeAnsi((String)currentValue);
        }
        Node rootNode = domContext.getRootNode();
        if (requiresContainingSpan) {
            domContext.setCursorParent(rootNode);
            if (rootNode.getFirstChild() != null && rootNode.getFirstChild() instanceof Text) {
                ((Text)rootNode.getFirstChild()).setData(currentValue);
            } else {
                Text text = domContext.getDocument().createTextNode(currentValue);
                rootNode.appendChild(text);
            }
        } else {
            ((Text)rootNode).setData(currentValue);
        }
    }

    private void renderUIInput(FacesContext facesContext, UIComponent uiComponent, String currentValue) throws IOException {
        Element root;
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (!domContext.isInitialized()) {
            root = domContext.createElement("input");
            domContext.setRootNode(root);
            TextRenderer.setRootElementId(facesContext, root, uiComponent);
            root.setAttribute("type", "text");
            root.setAttribute("name", uiComponent.getClientId(facesContext));
        }
        root = (Element)domContext.getRootNode();
        String bidi = (String)uiComponent.getAttributes().get("dir");
        if (bidi != null) {
            root.setAttribute("dir", bidi);
        }
        if (currentValue != null) {
            root.setAttribute("value", currentValue);
        } else {
            root.removeAttribute("value");
        }
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            root.setAttribute("class", styleClass);
        }
        this.addJavaScript(facesContext, uiComponent, root, currentValue);
        String mousedownScript = (String)uiComponent.getAttributes().get("onmousedown");
        root.setAttribute("onmousedown", TextRenderer.combinedPassThru(mousedownScript, "this.focus();"));
    }

    private boolean requiresContainingSpan(UIComponent uiComponent) {
        UIComponent parent = uiComponent.getParent();
        Boolean nospan = (Boolean)uiComponent.getAttributes().get("nospan");
        if (nospan != null && nospan.booleanValue()) {
            return false;
        }
        String style = (String)uiComponent.getAttributes().get("style");
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        String title = (String)uiComponent.getAttributes().get("title");
        if (styleClass != null || style != null || title != null) {
            return true;
        }
        return TextRenderer.idNotNull(uiComponent) && !uiComponent.getId().startsWith("_");
    }

    protected void addJavaScript(FacesContext facesContext, UIComponent uiComponent, Element root, String currentValue) {
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, input_passThruAttributes);
    }
}

