/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context.effects;

import com.icesoft.faces.context.effects.BlankEffect;
import com.icesoft.faces.context.effects.Effect;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.w3c.dom.Element;

public class LocalEffectEncoder {
    private static final String[] ALL_EVENTS = new String[]{"onblur", "onchange", "onclick", "oncontextmenu", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseover", "onmouseup", "onmouseout", "onreset", "onselect", "onsubmit"};
    private static final String[] ALL_EFFECTS = new String[]{null, "onchangeeffect", "onclickeffect", null, "ondblclickeffect", null, "onkeydowneffect", "onkeypresseffect", "onkeyupeffect", "onmousedowneffect", "onmousemoveeffect", "onmouseovereffect", "onmouseupeffect", "onmouseouteffect", "onreseteffect", null, "onsubmiteffect"};
    private static final String[] EVENTS = new String[]{"click", "dblclick", "mousedown", "mouseup", "mousemove", "mouseover", "mouseout", "change", "reset", "submit", "keypress", "keydown", "keyup"};
    private static String[] ATTRIBUTES = new String[EVENTS.length];
    private static final String ATTRIBUTE_PREFIX = "on";
    private static String[] EFFECTS = new String[EVENTS.length];
    private static final String EFFECT_SUFFIX = "effect";
    private static Logger log;

    public static String[] maskEvents(String[] passthruAttributes) {
        int len = ALL_EVENTS.length;
        String[] events = new String[len];
        block0: for (int i = 0; i < len; ++i) {
            String curr = ALL_EVENTS[i];
            for (int j = passthruAttributes.length - 1; j >= 0; --j) {
                if (!curr.equals(passthruAttributes[j])) continue;
                events[i] = curr;
                continue block0;
            }
        }
        return events;
    }

    public static void encode(FacesContext facesContext, UIComponent comp, String[] events, Map rendererValues, Element rootNode, ResponseWriter writer) {
        block7: {
            Map atts = comp.getAttributes();
            try {
                for (int i = 0; i < events.length; ++i) {
                    String currentEvent = events[i];
                    if (currentEvent == null) continue;
                    String effectValue = null;
                    if (ALL_EFFECTS[i] != null) {
                        Effect fx = (Effect)atts.get(ALL_EFFECTS[i]);
                        if (fx == null && comp.getValueBinding(ALL_EFFECTS[i]) != null) {
                            fx = new BlankEffect();
                        }
                        if (fx != null) {
                            effectValue = JavascriptContext.applyEffect(fx, comp.getClientId(facesContext), facesContext);
                        }
                    }
                    String applicationValue = (String)atts.get(currentEvent);
                    String rendererValue = rendererValues == null ? null : (String)rendererValues.get(currentEvent);
                    String value = DomBasicRenderer.combinedPassThru(DomBasicRenderer.combinedPassThru(effectValue, applicationValue), rendererValue);
                    if (value == null) continue;
                    if (rootNode != null) {
                        rootNode.setAttribute(currentEvent, value);
                        continue;
                    }
                    if (writer == null) continue;
                    writer.writeAttribute(currentEvent, (Object)value, null);
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.SEVERE)) break block7;
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public static void encodeLocalEffects(UIComponent comp, Element rootNode, FacesContext facesContext, ResponseWriter writer, boolean attribTracking, List attributesThatAreSet) {
        block6: {
            if (attribTracking && (attributesThatAreSet == null || attributesThatAreSet.size() == 0)) {
                return;
            }
            Map atts = comp.getAttributes();
            try {
                for (int i = 0; i < EVENTS.length; ++i) {
                    String original;
                    String value;
                    String together;
                    if (attribTracking && (attributesThatAreSet == null || !attributesThatAreSet.contains(EFFECTS[i]))) continue;
                    Effect fx = (Effect)atts.get(EFFECTS[i]);
                    if (fx == null && comp.getValueBinding(EFFECTS[i]) != null) {
                        fx = new BlankEffect();
                    }
                    if (fx == null || (together = DomBasicRenderer.combinedPassThru(value = JavascriptContext.applyEffect(fx, comp.getClientId(facesContext), facesContext), original = attribTracking && (attributesThatAreSet == null || !attributesThatAreSet.contains(ATTRIBUTES[i])) ? null : (String)atts.get(ATTRIBUTES[i]))) == null) continue;
                    if (rootNode != null) {
                        rootNode.setAttribute(ATTRIBUTES[i], together);
                        continue;
                    }
                    if (writer == null) continue;
                    writer.writeAttribute(ATTRIBUTES[i], (Object)together, null);
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.SEVERE)) break block6;
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public static void encodeLocalEffects(UIComponent comp, Element rootNode, FacesContext facesContext) {
        LocalEffectEncoder.encodeLocalEffects(comp, rootNode, facesContext, null, false, null);
    }

    public static void encodeLocalEffects(UIComponent comp, ResponseWriter writer, FacesContext facesContext) {
        LocalEffectEncoder.encodeLocalEffects(comp, null, facesContext, writer, false, null);
    }

    public static void encodeLocalEffect(String id, Effect fx, String event, FacesContext facesContext) {
        String value = JavascriptContext.applyEffect(fx, id, facesContext);
        String js = "Ice.Prototype.$('" + id + "').on" + event + "=function(){" + value + "};";
        JavascriptContext.addJavascriptCall(facesContext, js);
    }

    static {
        for (int index = 0; index < EVENTS.length; ++index) {
            LocalEffectEncoder.ATTRIBUTES[index] = ATTRIBUTE_PREFIX + EVENTS[index];
            LocalEffectEncoder.EFFECTS[index] = ATTRIBUTES[index] + EFFECT_SUFFIX;
        }
        log = Logger.getLogger("com.icesoft.faces.compat");
    }
}

