/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.lvg.ae;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.ctakes.lvg.ae.LvgAnnotator;
import org.apache.ctakes.lvg.resource.LvgCmdApiResourceImpl;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.ExternalResourceFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.ResourceInitializationException;

enum LvgSingleton {
    INSTANCE;

    public static final String PROPERTIES_PATH = "org/apache/ctakes/lvg/data/config/lvg.properties";
    private final Logger LOGGER = Logger.getLogger((String)"LvgSingleton");
    private final Object LOCK = new Object();
    private final LvgAnnotator _lvgAnnotator = new LvgAnnotator();
    private ExternalResourceDescription _lvgCmdApi;
    private boolean _initialized;

    public static LvgSingleton getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(UimaContext context) throws ResourceInitializationException {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this._initialized) {
                this._initialized = true;
                this._lvgAnnotator.initialize(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Object object = this.LOCK;
        synchronized (object) {
            this._lvgAnnotator.process(jCas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalResourceDescription getDefaultLvgCmdApi() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            if (this._lvgCmdApi != null) {
                return this._lvgCmdApi;
            }
            URL url = LvgAnnotator.class.getClassLoader().getResource(PROPERTIES_PATH);
            if (url != null) {
                this.LOGGER.info((Object)("URL for lvg.properties =" + url.getFile()));
            } else {
                String absolutePath = "/tmp/";
                this.LOGGER.info((Object)"URL==null");
                this.LOGGER.info((Object)"Unable to find org/apache/ctakes/lvg/data/config/lvg.properties.");
                this.LOGGER.info((Object)("Copying files and directories to under " + absolutePath));
                File lvgFile = new File(LvgAnnotator.copyLvgFiles(absolutePath));
                url = lvgFile.toURI().toURL();
            }
            this._lvgCmdApi = ExternalResourceFactory.createExternalResourceDescription(LvgCmdApiResourceImpl.class, (URL)url, (Object[])new Object[0]);
            return this._lvgCmdApi;
        }
    }
}

