/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Trie.PersistentExceptionNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentList;
import gov.nih.nlm.nls.lvg.Trie.PersistentListNode;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PersistentRuleNode
extends PersistentListNode {
    private String ruleStr_ = null;
    private long exceptionAddress_ = -1L;

    public PersistentRuleNode(long address) {
        super(address);
    }

    public PersistentRuleNode(long address, long next) {
        super(address, next);
    }

    public PersistentRuleNode(String ruleStr, long exceptionAddress) {
        this.ruleStr_ = ruleStr;
        this.exceptionAddress_ = exceptionAddress;
    }

    public String GetRuleString() {
        return this.ruleStr_;
    }

    public long GetExceptionAddress() {
        return this.exceptionAddress_;
    }

    @Override
    public void WriteData(RandomAccessFile raf) throws IOException {
        raf.writeUTF(this.ruleStr_);
        raf.writeLong(this.exceptionAddress_);
    }

    @Override
    public void ReadData(RandomAccessFile raf) throws IOException {
        this.ruleStr_ = raf.readUTF();
        this.exceptionAddress_ = raf.readLong();
    }

    public static PersistentListNode GetNode(RandomAccessFile raf, long address) throws IOException {
        PersistentRuleNode node = new PersistentRuleNode(address);
        raf.seek(address);
        node.ReadData(raf);
        long next = raf.readLong();
        node.SetNext(next);
        return node;
    }

    public static void PrintList(String rulePath, String exceptionPath, long address) throws IOException {
        PersistentList persistentRule = new PersistentList(rulePath);
        RandomAccessFile ruleRaf = persistentRule.GetRaf();
        long curAddress = address + 12L;
        ruleRaf.seek(curAddress);
        int i = 0;
        while (curAddress != -1L) {
            PersistentRuleNode curNode = (PersistentRuleNode)PersistentRuleNode.GetNode(ruleRaf, curAddress);
            long exceptionAddress = curNode.GetExceptionAddress();
            System.out.println("    R-" + i + ": '" + curNode.GetRuleString() + "': " + exceptionAddress);
            curAddress = curNode.GetNext();
            ++i;
            if (exceptionAddress == -1L) continue;
            PersistentExceptionNode.PrintList(exceptionPath, exceptionAddress);
        }
        persistentRule.Close();
    }
}

