/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Tools.GuiTool.Global;

import gov.nih.nlm.nls.lvg.Api.LvgLexItemApi;
import gov.nih.nlm.nls.lvg.Api.ToAsciiApi;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LvgOutputOption;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Global.LvgCommand;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.InputOptionDialog;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.InputPanel;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.MutatePanel;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.OutputPanel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class LvgGlobal {
    public static LvgCommand cmd_ = new LvgCommand();
    private static Vector<LexItem> outputLexItems_ = new Vector();
    private static Vector<String> outputStrs_ = new Vector();
    private static String outputStr_ = new String();
    public static Configuration config_ = new Configuration("data.config.lvg", true);
    public static LvgLexItemApi lvg_ = new LvgLexItemApi();
    public static ToAsciiApi toAscii_ = new ToAsciiApi(config_);
    public static boolean inputFromScreen_ = true;
    public static boolean outputToScreen_ = true;
    private static String curDir_ = System.getProperty("user.dir");
    public static File inFile_ = new File(curDir_ + "/in.data");
    public static File outFile_ = new File(curDir_ + "/out.data");
    public static File confFile_ = new File(curDir_);
    public static boolean outAppendFlag_ = false;
    public static LvgOutputOption outputOption_ = new LvgOutputOption();
    public static boolean mutateFlag_ = false;
    public static boolean detailsFlag_ = false;
    public static String separator_ = "|";

    private LvgGlobal() {
    }

    public static void SetConfig(String config) {
        config_ = new Configuration(config, false);
        lvg_ = new LvgLexItemApi("", config);
    }

    public static Vector<LexItem> GetOutputLexItems() {
        return outputLexItems_;
    }

    public static Vector<String> GetOutputStrings() {
        return outputStrs_;
    }

    public static void LvgMutate(int program) {
        if (program == 4) {
            if (inputFromScreen_) {
                LvgGlobal.ToAscii(InputPanel.GetLexItem());
            } else if (outputToScreen_) {
                LvgGlobal.ToAscii(inFile_);
            } else if (!outputToScreen_) {
                LvgGlobal.ToAscii(inFile_, outFile_);
            }
        } else if (inputFromScreen_) {
            LvgGlobal.LvgMutate(InputPanel.GetLexItem(), InputPanel.GetInLine());
        } else if (outputToScreen_) {
            LvgGlobal.LvgMutate(inFile_);
        } else if (!outputToScreen_) {
            LvgGlobal.LvgMutate(inFile_, outFile_);
        }
    }

    private static void ToAscii(LexItem inLexItem) {
        LexItem outLexItem = toAscii_.Mutate(inLexItem, detailsFlag_);
        String asciiStr = outLexItem.GetTargetTerm();
        String ls = System.getProperty("line.separator").toString();
        if (detailsFlag_) {
            asciiStr = asciiStr + ls + outLexItem.GetDetailInformation();
        }
        LvgGlobal.ResetOutputStrings();
        outputLexItems_.removeAllElements();
        outputLexItems_.add(outLexItem);
        if (outputToScreen_) {
            StringTokenizer buf = new StringTokenizer(asciiStr, ls);
            while (buf.hasMoreTokens()) {
                outputStrs_.addElement(buf.nextToken());
            }
            OutputPanel.UpdateResult();
        } else {
            outputStr_ = asciiStr;
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(outFile_.getPath(), outAppendFlag_));
                out.write(outputStr_);
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            OutputPanel.SetOutputMessage();
        }
    }

    private static void ToAscii(File inFile) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            String line = null;
            boolean firstTimeRead = true;
            LvgGlobal.ResetOutputStrings();
            while ((line = in.readLine()) != null) {
                if (firstTimeRead) {
                    MutatePanel.SetNotLvg(line);
                    firstTimeRead = false;
                }
                LexItem inLexItem = new LexItem(line);
                LexItem outLexItem = toAscii_.Mutate(inLexItem, detailsFlag_);
                String asciiStr = outLexItem.GetTargetTerm();
                String ls = System.getProperty("line.separator").toString();
                if (detailsFlag_) {
                    asciiStr = asciiStr + ls + outLexItem.GetDetailInformation();
                }
                StringTokenizer buf = new StringTokenizer(asciiStr, ls);
                while (buf.hasMoreTokens()) {
                    outputStrs_.addElement(buf.nextToken());
                }
                OutputPanel.UpdateResult();
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("** Error: incorrect input file, " + e.getMessage());
        }
    }

    private static void ToAscii(File inFile, File outFile) {
        try {
            String line = null;
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile_.getPath(), outAppendFlag_));
            boolean firstTimeRead = true;
            LvgGlobal.ResetOutputStrings();
            while ((line = in.readLine()) != null) {
                if (firstTimeRead) {
                    MutatePanel.SetNotLvg(line);
                    firstTimeRead = false;
                }
                LexItem inLexItem = new LexItem(line);
                LexItem outLexItem = toAscii_.Mutate(inLexItem, detailsFlag_);
                String asciiStr = outLexItem.GetTargetTerm();
                String ls = System.getProperty("line.separator").toString();
                asciiStr = detailsFlag_ ? asciiStr + ls + outLexItem.GetDetailInformation() : asciiStr + ls;
                outputStr_ = asciiStr;
                out.write(outputStr_);
            }
            in.close();
            out.close();
            OutputPanel.SetOutputMessage();
        }
        catch (Exception e) {
            System.err.println("** Error: incorrect input file, " + e.getMessage());
        }
    }

    private static void LvgMutate(LexItem input, String inLine) {
        outputLexItems_.removeAllElements();
        outputLexItems_ = LvgGlobal.Process(input);
        LvgGlobal.UpdateOutputStrings(outputLexItems_, inLine, false);
        if (outputToScreen_) {
            OutputPanel.UpdateResult();
        } else {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(outFile_.getPath(), outAppendFlag_));
                out.write(outputStr_);
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            OutputPanel.SetOutputMessage();
        }
    }

    private static void LvgMutate(File inFile) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            String line = null;
            boolean firstTimeRead = true;
            outputLexItems_.removeAllElements();
            LvgGlobal.ResetOutputStrings();
            while ((line = in.readLine()) != null) {
                if (firstTimeRead) {
                    MutatePanel.SetNotLvg(line);
                    firstTimeRead = false;
                }
                LexItem inLexItem = LvgGlobal.SetLexItem(line);
                Vector<LexItem> result = LvgGlobal.Process(inLexItem);
                LvgGlobal.UpdateOutputStrings(result, line, true);
                outputLexItems_.addAll(result);
                OutputPanel.UpdateResult();
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("** Error: incorrect input file, " + e.getMessage());
        }
    }

    private static void LvgMutate(File inFile, File outFile) {
        try {
            String line = null;
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile_.getPath(), outAppendFlag_));
            boolean firstTimeRead = true;
            outputLexItems_.removeAllElements();
            while ((line = in.readLine()) != null) {
                if (firstTimeRead) {
                    MutatePanel.SetNotLvg(line);
                    firstTimeRead = false;
                }
                LexItem inLexItem = LvgGlobal.SetLexItem(line);
                Vector<LexItem> result = LvgGlobal.Process(inLexItem);
                LvgGlobal.UpdateOutputStrings(result, line, true);
                out.write(outputStr_);
                LvgGlobal.ResetOutputStrings();
            }
            in.close();
            out.close();
            OutputPanel.SetOutputMessage();
        }
        catch (Exception e) {
            System.err.println("** Error: incorrect input file, " + e.getMessage());
        }
    }

    private static void ResetOutputs() {
        outputLexItems_.removeAllElements();
        outputStrs_.removeAllElements();
        outputStr_ = new String();
    }

    private static LexItem SetLexItem(String inLine) {
        String separator = separator_;
        int termFieldNum = InputOptionDialog.GetTermFieldNum();
        String term = InputFilter.GetInputTerm(inLine, separator, termFieldNum);
        LexItem lexItem = new LexItem(term);
        int categoryFieldNum = InputOptionDialog.GetCategoryFieldNum();
        if (categoryFieldNum > 0) {
            long inCat = InputFilter.GetInputCategory(inLine, separator, categoryFieldNum);
            lexItem.SetSourceCategory(inCat);
        } else {
            lexItem.SetSourceCategory(2047L);
        }
        int inflectionFieldNum = InputOptionDialog.GetInflectionFieldNum();
        if (inflectionFieldNum > 0) {
            long inInfl = InputFilter.GetInputInflection(inLine, separator, inflectionFieldNum);
            lexItem.SetSourceInflection(inInfl);
        } else {
            lexItem.SetSourceInflection(0xFFFFFFL);
        }
        return lexItem;
    }

    public static void UpdateCmdStr() {
        cmd_.UpdateCmdStr();
        MutatePanel.SetCommand(cmd_.GetCmdStr());
    }

    private static Vector<LexItem> Process(LexItem inLexItem) {
        Vector<LexItem> outputs = new Vector();
        lvg_.SetOption(cmd_.GetCmdStr());
        try {
            outputs = lvg_.ProcessLexItem(inLexItem);
        }
        catch (Exception e) {
            System.err.println("** Error: " + e.toString());
        }
        return outputs;
    }

    private static void ResetOutputStrings() {
        outputStr_ = new String();
        outputStrs_.removeAllElements();
    }

    public static void UpdateOutputStrings(Vector<LexItem> output, String inLine, boolean append) {
        if (!append) {
            LvgGlobal.ResetOutputStrings();
        }
        String curOutputStr = OutputFilter.ExecuteOutputFilter(output, mutateFlag_, detailsFlag_, separator_, inLine, outputOption_);
        outputStr_ = outputStr_ + curOutputStr;
        String ls = System.getProperty("line.separator").toString();
        StringTokenizer buf = new StringTokenizer(curOutputStr, ls);
        while (buf.hasMoreTokens()) {
            outputStrs_.addElement(buf.nextToken());
        }
    }
}

