/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.UnicodeUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToStripMapUnicode
extends Transformation
implements Cloneable {
    private static final String INFO = "Strip or Map Unicode to ASCII";
    private static final String NO_OPERATION = "NO";
    private static final String MAPPING = "MP";
    private static final String STRIPPING = "SP";

    public static Vector<LexItem> Mutate(LexItem in, Hashtable<Character, String> nonStripMap, boolean detailsFlag, boolean mutateFlag) {
        Vector<LexItem> out = ToStripMapUnicode.StripMapUnicodeToAscii(in, nonStripMap, INFO, detailsFlag, mutateFlag);
        return out;
    }

    public static Hashtable<Character, String> GetNonStripMapFromFile(Configuration config) {
        String fName = config.GetConfiguration("LVG_DIR") + config.GetConfiguration("LVG_NON_STRIP_MAP_UNICODE_FILE");
        String line = null;
        Hashtable<Character, String> nonStripMap = new Hashtable<Character, String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fName), "UTF-8"));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                StringTokenizer buf = new StringTokenizer(line, "|", true);
                char inChar = (char)UnicodeUtil.UnicodeHexToNum(buf.nextToken());
                Character nonStripUnicode = new Character(inChar);
                buf.nextToken();
                int nextTokenIndex = 0;
                String mapStr = new String();
                while (buf.hasMoreTokens()) {
                    String curToken = buf.nextToken();
                    if (!curToken.equals("|")) {
                        if (nextTokenIndex == 0) {
                            mapStr = curToken;
                            break;
                        }
                        for (int i = 0; i < nextTokenIndex - 1; ++i) {
                            mapStr = mapStr + "|";
                        }
                        break;
                    }
                    ++nextTokenIndex;
                }
                if (UnicodeUtil.IsAsciiChar(inChar) || !UnicodeUtil.IsAsciiStr(mapStr)) {
                    System.err.println("** Warning: Illegal format in nonStripMap file: '" + fName + "'.");
                    System.err.println(line);
                    continue;
                }
                nonStripMap.put(nonStripUnicode, mapStr);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("** Error: problem of opening/reading nonStripMap file: '" + fName + "'.");
            System.err.println("Exception: " + e.toString());
        }
        return nonStripMap;
    }

    public static String StripMapUnicodeToAscii(char inChar, Hashtable<Character, String> nonStripMap) {
        if (UnicodeUtil.IsAsciiChar(inChar)) {
            return String.valueOf(inChar);
        }
        String outStr = new String();
        if (nonStripMap.containsKey(Character.valueOf(inChar))) {
            outStr = nonStripMap.get(Character.valueOf(inChar));
        }
        return outStr;
    }

    public static void main(String[] args) {
        String testStr = ToStripMapUnicode.GetTestStr(args, "\u00a9 and \u00b5");
        Configuration conf = new Configuration("data.config.lvg", true);
        Hashtable<Character, String> nonStripMap = ToStripMapUnicode.GetNonStripMapFromFile(conf);
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToStripMapUnicode.Mutate(in, nonStripMap, true, true);
        ToStripMapUnicode.PrintResults(in, outs);
    }

    private static Vector<LexItem> StripMapUnicodeToAscii(LexItem in, Hashtable<Character, String> nonStripMap, String infoStr, boolean detailsFlag, boolean mutateFlag) {
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = infoStr;
        }
        if (mutateFlag) {
            mutate = new String();
        }
        String inStr = in.GetSourceTerm();
        String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < inStr.length(); ++i) {
            char curChar = inStr.charAt(i);
            String opStr = NO_OPERATION + fs;
            if (UnicodeUtil.IsAsciiChar(curChar)) {
                buffer.append(curChar);
            } else {
                Character key = new Character(curChar);
                if (nonStripMap.containsKey(key)) {
                    buffer.append(nonStripMap.get(key));
                    opStr = MAPPING + fs;
                } else {
                    opStr = STRIPPING + fs;
                }
            }
            if (!mutateFlag) continue;
            mutate = mutate + opStr;
        }
        String term = buffer.toString();
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToStripMapUnicode.UpdateLexItem(in, term, 62, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }
}

