/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.CmdLineSyntax;

import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionFlag;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionList;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Option {
    public static final int MAX_LEVEL = 5;
    public static final char ARGUMENT_SEP = '+';
    public static final char[] SEPARATOR = new char[]{'-', ':', '~', '^', '#'};
    public static final String ROOT = "Root";
    public static final String BOOLEAN_ARGUMENT = "BLN";
    public static final String STRING_ARGUMENT = "STR";
    public static final String INT_ARGUMENT = "INT";
    public static final String LONG_ARGUMENT = "LONG";
    public static final String FLOAT_ARGUMENT = "FLT";
    private String[] parentStr_ = new String[]{"", "", "", "", ""};
    private String optionStr_ = null;
    private OptionList<OptionFlag> optionList_ = new OptionList();
    private Vector<OptionItem> optionItems_ = new Vector(1);

    public Option(String optionStr) {
        this.optionStr_ = optionStr;
        this.FormOptionList(optionStr);
        this.Init();
    }

    public Option(OptionList<OptionFlag> optionList) {
        this.optionStr_ = OptionUtility.ToOptionString(optionList);
        this.optionList_ = optionList;
        this.Init();
    }

    public static Option GetOptonByArgs(String[] args) {
        String optionStr = "";
        Option io = new Option(optionStr);
        if (args.length > 0) {
            optionStr = new String();
            for (int i = 0; i < args.length; ++i) {
                optionStr = i == 0 ? args[i] : optionStr + " " + args[i];
            }
            io = new Option(optionStr);
        }
        return io;
    }

    public void SetFlagFullName(String item, String fullName) {
        OptionFlag flag = this.GetOptionFlag(this.optionList_, item, 0);
        if (flag != null) {
            flag.SetFullName(fullName);
        }
    }

    public String GetOptionStr() {
        return this.optionStr_;
    }

    public OptionList<OptionFlag> GetOptionList() {
        return this.optionList_;
    }

    public Vector<OptionItem> GetOptionItems() {
        return this.optionItems_;
    }

    public Vector<String> GetOptionItemStrs() {
        return this.GetOptionItem(this.optionList_);
    }

    public void PrintOptionHierachy() {
        this.PrintOptionList(this.optionList_);
    }

    public void PrintOptionLeaf() {
        this.PrintOptionItems(this.optionList_);
    }

    public static void main(String[] args) {
        Option o = new Option("-a:aa~123+45+78:ab~aba~12:ac:ad~ada -b:bb:bc~bca+bcb:bd:be -c");
        if (args.length > 0) {
            String optionStr = "";
            for (int i = 0; i < args.length; ++i) {
                optionStr = optionStr + args[i];
            }
            o = new Option(optionStr);
        }
        System.out.println("------------ Option String --------------");
        System.out.println("Option String: " + o.GetOptionStr());
        System.out.println("------------ Hierachy -------------------");
        o.PrintOptionHierachy();
        System.out.println("------------ Option Leaf -------------------");
        o.PrintOptionLeaf();
        System.out.println("------------ Option String -------------------");
        System.out.println(OptionUtility.ToOptionString(o.GetOptionList()));
        Option o1 = new Option(o.GetOptionList());
        System.out.println("------------ Option1 String -------------------");
        System.out.println(o1.GetOptionStr());
        System.out.println("------------ GetOptionStr() -------------------");
        System.out.println(OptionUtility.GetOptionStr(o1.GetOptionItems()));
    }

    private void Init() {
        Vector<String> optionItemStrs = this.GetOptionItemStrs();
        for (int i = 0; i < optionItemStrs.size(); ++i) {
            String optionItemStr = optionItemStrs.elementAt(i);
            OptionItem optionItem = new OptionItem(optionItemStr);
            this.optionItems_.addElement(optionItem);
        }
    }

    private Vector<String> GetOptionItem(OptionList<OptionFlag> optionList) {
        Vector<String> optionItems = new Vector<String>(1);
        ListIterator lit = optionList.listIterator();
        while (lit.hasNext()) {
            int i;
            OptionFlag flag = (OptionFlag)lit.next();
            if (flag.GetChild() != null) {
                this.parentStr_[flag.GetLevel()] = flag.GetName();
                Vector<String> childItems = this.GetOptionItem(flag.GetChild());
                for (i = 0; i < childItems.size(); ++i) {
                    optionItems.addElement(childItems.elementAt(i));
                }
                continue;
            }
            String flagStr = "";
            for (i = 0; i < flag.GetLevel(); ++i) {
                flagStr = flagStr + SEPARATOR[i] + this.parentStr_[i];
            }
            flagStr = flagStr + SEPARATOR[flag.GetLevel()] + flag.GetName();
            optionItems.addElement(flagStr);
        }
        return optionItems;
    }

    private void PrintOptionItems(OptionList<OptionFlag> optionList) {
        Vector<String> optionItems = this.GetOptionItem(optionList);
        for (int i = 0; i < optionItems.size(); ++i) {
            String optionItemStr = optionItems.elementAt(i);
            System.out.println(optionItemStr + "=> " + OptionItem.GetOptionFlag(optionItemStr) + ", " + OptionItem.GetOptionArgument(optionItemStr));
        }
    }

    private void PrintOptionList(OptionList<OptionFlag> optionList) {
        ListIterator lit = optionList.listIterator();
        while (lit.hasNext()) {
            OptionFlag flag = (OptionFlag)lit.next();
            this.PrintLevelIndent(flag.GetLevel());
            System.out.print(" " + flag.GetName());
            if (flag.GetFullName() == null) {
                System.out.println("");
            } else {
                System.out.println(" (" + flag.GetFullName() + ")");
            }
            if (flag.GetChild() == null) continue;
            this.PrintOptionList(flag.GetChild());
        }
    }

    private void PrintLevelIndent(int level) {
        int numOfDash = level * 2 + 1;
        for (int i = 0; i < numOfDash; ++i) {
            System.out.print("-");
        }
    }

    private void FormOptionList(String optionStr) {
        this.Compose(optionStr, 0);
    }

    private void Compose(String optionStr, int curLevel) {
        if (curLevel < 5) {
            String delimiter = " " + SEPARATOR[curLevel];
            StringTokenizer buf = new StringTokenizer(optionStr, delimiter);
            while (buf.hasMoreTokens()) {
                String token = buf.nextToken();
                this.AddCurFlag(token, curLevel);
                String nextLevelItemStr = this.GetNextLevelItemStr(token, curLevel);
                if (nextLevelItemStr != null) {
                    this.Compose(nextLevelItemStr, curLevel + 1);
                    continue;
                }
                if (buf.hasMoreTokens()) continue;
                return;
            }
        } else {
            System.err.println("** Error: curLevel is too large (" + curLevel + ").");
        }
    }

    private void AddCurFlag(String str, int curLevel) {
        String delimiter = "" + SEPARATOR[curLevel + 1];
        StringTokenizer buf = new StringTokenizer(str, delimiter);
        String curFlag = buf.nextToken();
        this.optionList_.AddOptionFlag(new OptionFlag(curFlag, curLevel));
    }

    private String GetNextLevelItemStr(String str, int curLevel) {
        String nextLevelStr = null;
        int index = str.indexOf(SEPARATOR[curLevel + 1]);
        if (index != -1) {
            nextLevelStr = str.substring(index);
        }
        return nextLevelStr;
    }

    private OptionFlag GetOptionFlag(OptionList<OptionFlag> optionList, String item, int curLevel) {
        OptionFlag flag = null;
        ListIterator lit = optionList.listIterator();
        while (lit.hasNext()) {
            flag = (OptionFlag)lit.next();
            if (!flag.GetName().equals(OptionUtility.GetLevelFlag(item, curLevel))) continue;
            optionList = flag.GetChild();
            if (++curLevel <= OptionUtility.GetLevelNum(item)) {
                flag = this.GetOptionFlag(optionList, item, curLevel);
            }
            return flag;
        }
        System.err.println("** Error: Can't find a matched OptionFlag for '" + item + "'");
        flag = null;
        return flag;
    }
}

