/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.libsvm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.ytex.kernel.BaseClassifierEvaluationParser;
import org.apache.ctakes.ytex.kernel.ClassifierEvaluationParser;
import org.apache.ctakes.ytex.kernel.model.ClassifierEvaluation;
import org.apache.ctakes.ytex.kernel.model.ClassifierInstanceEvaluation;
import org.apache.ctakes.ytex.kernel.model.SVMClassifierEvaluation;

public class LibSVMParser
extends BaseClassifierEvaluationParser {
    public static Pattern labelsPattern = Pattern.compile("labels\\s+(.*)");
    public static Pattern totalSVPattern = Pattern.compile("total_sv (\\d+)");
    public static Pattern pKernel = Pattern.compile("-t\\s+(\\d)");
    public static Pattern pGamma = Pattern.compile("-g\\s+([\\d\\.eE-]+)");
    public static Pattern pCost = Pattern.compile("-c\\s+([\\d\\.eE-]+)");
    public static Pattern pWeight = Pattern.compile("-w-{0,1}\\d\\s+[\\d\\.]+\\b");
    public static Pattern pDegree = Pattern.compile("-d\\s+(\\d+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer parseModel(String modelFile) throws IOException {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(modelFile));
            String line = null;
            while ((line = r.readLine()) != null) {
                Matcher m = totalSVPattern.matcher(line);
                if (!m.find()) continue;
                Integer n = new Integer(m.group(1));
                return n;
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception e) {
                System.err.println("reading model file");
                e.printStackTrace(System.err);
            }
        }
        return null;
    }

    protected List<Integer> parseClassIds(BufferedReader predictionReader) throws IOException {
        String[] labelsA;
        ArrayList<Integer> labels = null;
        String labelLine = predictionReader.readLine();
        Matcher labelMatcher = labelsPattern.matcher(labelLine);
        if (labelMatcher.find() && (labelsA = wsPattern.split(labelMatcher.group(1))) != null && labelsA.length > 0) {
            labels = new ArrayList<Integer>(labelsA.length);
            for (String label : labelsA) {
                labels.add(Integer.parseInt(label));
            }
        }
        return labels;
    }

    protected SVMClassifierEvaluation initClassifierEval(String name, String experiment, String label, String options, String instanceIdFile) {
        SVMClassifierEvaluation eval = new SVMClassifierEvaluation();
        this.initClassifierEval(name, experiment, label, options, instanceIdFile, eval);
        return eval;
    }

    private void initClassifierEval(String name, String experiment, String label, String options, String instanceIdFile, ClassifierEvaluation eval) {
        this.initClassifierEvaluation(instanceIdFile, eval);
        eval.setName(name);
        eval.setExperiment(experiment);
        eval.setOptions(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parsePredictions(String predictionFile, String instanceFile, Properties props, String instanceIdFile, SVMClassifierEvaluation eval) throws IOException {
        boolean storeProbabilities = "yes".equalsIgnoreCase(props.getProperty(ClassifierEvaluationParser.ParseOption.STORE_PROBABILITIES.getOptionKey(), ClassifierEvaluationParser.ParseOption.STORE_PROBABILITIES.getDefaultValue()));
        List<Long> instanceIds = null;
        if (instanceIdFile != null) {
            instanceIds = this.parseInstanceIds(instanceIdFile);
        }
        BufferedReader instanceReader = null;
        BufferedReader predictionReader = null;
        try {
            instanceReader = new BufferedReader(new FileReader(instanceFile));
            predictionReader = new BufferedReader(new FileReader(predictionFile));
            String instanceLine = null;
            String predictionLine = null;
            int nLine = 0;
            List<Integer> classIds = this.parseClassIds(predictionReader);
            while ((instanceLine = instanceReader.readLine()) != null && (predictionLine = predictionReader.readLine()) != null) {
                long instanceId = instanceIds.size() > nLine ? instanceIds.get(nLine) : (long)nLine;
                ++nLine;
                ClassifierInstanceEvaluation instanceEval = new ClassifierInstanceEvaluation();
                String[] predictTokens = wsPattern.split(predictionLine);
                String classIdPredicted = predictTokens[0];
                String classIdTarget = LibSVMParser.extractFirstToken(instanceLine, wsPattern);
                instanceEval.setTargetClassId(Integer.parseInt(classIdTarget));
                instanceEval.setPredictedClassId(Integer.parseInt(classIdPredicted));
                instanceEval.setInstanceId(instanceId);
                instanceEval.setClassifierEvaluation(eval);
                eval.getClassifierInstanceEvaluations().put(instanceId, instanceEval);
                if (!storeProbabilities || predictTokens.length <= 1) continue;
                for (int i = 1; i < predictTokens.length; ++i) {
                    instanceEval.getClassifierInstanceProbabilities().put(classIds.get(i - 1), Double.parseDouble(predictTokens[i]));
                }
            }
        }
        finally {
            if (instanceReader != null) {
                try {
                    instanceReader.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            if (predictionReader != null) {
                try {
                    predictionReader.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    protected void parseOptions(SVMClassifierEvaluation eval, String options) {
        if (options != null) {
            eval.setKernel(this.parseIntOption(pKernel, options));
            if (eval.getKernel() == null) {
                eval.setKernel(0);
            }
            eval.setDegree(this.parseIntOption(pDegree, options));
            eval.setWeight(this.parseWeight(options));
            eval.setCost(this.parseDoubleOption(pCost, options));
            eval.setGamma(this.parseDoubleOption(pGamma, options));
        }
    }

    private String parseWeight(String options) {
        StringBuilder bWeight = new StringBuilder();
        Matcher m = pWeight.matcher(options);
        boolean bWeightParam = false;
        while (m.find()) {
            bWeightParam = true;
            bWeight.append(m.group()).append(" ");
        }
        if (bWeightParam) {
            return bWeight.toString();
        }
        return null;
    }

    @Override
    public void parseDirectory(File dataDir, File outputDir) throws IOException {
        String model = outputDir.getPath() + File.separator + "model.txt";
        String predict = outputDir.getPath() + File.separator + "predict.txt";
        String optionsFile = outputDir.getPath() + File.separator + "options.properties";
        if (this.checkFileRead(model) && this.checkFileRead(predict) && this.checkFileRead(optionsFile)) {
            Properties props = this.loadProps(outputDir);
            SVMClassifierEvaluation eval = new SVMClassifierEvaluation();
            eval.setAlgorithm("libsvm");
            this.parseResults(dataDir, outputDir, model, predict, eval, props);
            this.storeResults(dataDir, props, eval);
        }
    }

    protected void storeResults(File dataDir, Properties props, SVMClassifierEvaluation eval) throws IOException {
        this.getClassifierEvaluationDao().saveClassifierEvaluation(eval, (Map<Integer, String>)this.loadClassIdMap(dataDir, eval.getLabel()), "yes".equalsIgnoreCase(props.getProperty(ClassifierEvaluationParser.ParseOption.STORE_INSTANCE_EVAL.getOptionKey(), ClassifierEvaluationParser.ParseOption.STORE_INSTANCE_EVAL.getDefaultValue())));
    }

    protected void parseResults(File dataDir, File outputDir, String model, String predict, SVMClassifierEvaluation eval, Properties props) throws IOException {
        this.initClassifierEvaluationFromProperties(props, eval);
        eval.setSupportVectors(this.parseModel(model));
        this.parseOptions(eval, props.getProperty(ClassifierEvaluationParser.ParseOption.EVAL_LINE.getOptionKey()));
        String fileBaseName = this.getFileBaseName(props);
        this.initClassifierEvaluation(fileBaseName, eval);
        String instanceIdFile = dataDir + File.separator + fileBaseName + "test_id.txt";
        String instanceFile = dataDir + File.separator + fileBaseName + "test_data.txt";
        this.parsePredictions(predict, instanceFile, props, instanceIdFile, eval);
    }
}

