/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.lexicalscope.jewel.cli.CliFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.ClearTKDocTimeRelAnnotator;
import org.apache.ctakes.temporal.ae.ClearTKDocumentCreationTimeAnnotator;
import org.apache.ctakes.temporal.ae.EventToClearTKEventAnnotator;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.refsem.EventProperties;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.opennlp.tools.ParserAnnotator;
import org.cleartk.opennlp.tools.PosTaggerAnnotator;
import org.cleartk.opennlp.tools.SentenceAnnotator;
import org.cleartk.snowball.DefaultSnowballStemmer;
import org.cleartk.timeml.event.EventAspectAnnotator;
import org.cleartk.timeml.event.EventClassAnnotator;
import org.cleartk.timeml.event.EventModalityAnnotator;
import org.cleartk.timeml.event.EventPolarityAnnotator;
import org.cleartk.timeml.event.EventTenseAnnotator;
import org.cleartk.timeml.tlink.TemporalLinkEventToDocumentCreationTimeAnnotator;
import org.cleartk.token.tokenizer.TokenAnnotator;

public class EvaluationOfClearTKEventProperties
extends Evaluation_ImplBase<Map<String, AnnotationStatistics<String>>> {
    private static final String DOC_TIME_REL = "docTimeRel";
    private static final List<String> PROPERTY_NAMES = Arrays.asList("docTimeRel");
    private Map<String, Logger> loggers = Maps.newHashMap();

    public static void main(String[] args) throws Exception {
        Evaluation_ImplBase.Options options = (Evaluation_ImplBase.Options)CliFactory.parseArguments(Evaluation_ImplBase.Options.class, (String[])args);
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = EvaluationOfClearTKEventProperties.getTrainItems(options);
        List<Integer> testItems = EvaluationOfClearTKEventProperties.getTestItems(options);
        EvaluationOfClearTKEventProperties evaluation = new EvaluationOfClearTKEventProperties(new File("target/eval/event-properties"), options.getRawTextDirectory(), options.getXMLDirectory(), options.getXMLFormat(), options.getSubcorpus(), options.getXMIDirectory());
        evaluation.prepareXMIsFor(patientSets);
        evaluation.logClassificationErrors(new File("target/eval"), "ctakes-event-property-errors");
        Map stats = (Map)evaluation.trainAndTest(trainItems, testItems);
        for (String name : PROPERTY_NAMES) {
            System.err.println("====================");
            System.err.println(name);
            System.err.println("--------------------");
            System.err.println(stats.get(name));
        }
    }

    public EvaluationOfClearTKEventProperties(File baseDirectory, File rawTextDirectory, File xmlDirectory, Evaluation_ImplBase.XMLFormat xmlFormat, Evaluation_ImplBase.Subcorpus subcorpus, File xmiDirectory) {
        super(baseDirectory, rawTextDirectory, xmlDirectory, xmlFormat, subcorpus, xmiDirectory, null);
        for (String name : PROPERTY_NAMES) {
            this.loggers.put(name, Logger.getLogger(String.format("%s.%s", ((Object)((Object)this)).getClass().getName(), name)));
        }
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class), new String[0]);
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventProperties.class), new String[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{aggregateBuilder.createAggregate()});
    }

    protected Map<String, AnnotationStatistics<String>> test(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class), new String[0]);
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(TimeMention.class), new String[0]);
        aggregateBuilder.add(SentenceAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(TokenAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(PosTaggerAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(DefaultSnowballStemmer.getDescription((String)"English"), new String[0]);
        aggregateBuilder.add(ParserAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(EventToClearTKEventAnnotator.getAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(ClearTKDocumentCreationTimeAnnotator.getAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(EventTenseAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/event/eventtenseannotator/model.jar"), new String[0]);
        aggregateBuilder.add(EventAspectAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/event/eventaspectannotator/model.jar"), new String[0]);
        aggregateBuilder.add(EventClassAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/event/eventclassannotator/model.jar"), new String[0]);
        aggregateBuilder.add(EventPolarityAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/event/eventpolarityannotator/model.jar"), new String[0]);
        aggregateBuilder.add(EventModalityAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/event/eventmodalityannotator/model.jar"), new String[0]);
        aggregateBuilder.add(TemporalLinkEventToDocumentCreationTimeAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/tlink/temporallinkeventtodocumentcreationtimeannotator/model.jar"), new String[0]);
        aggregateBuilder.add(ClearTKDocTimeRelAnnotator.getAnnotatorDescription(), new String[0]);
        Function eventMentionToSpan = AnnotationStatistics.annotationToSpan();
        HashMap<String, Function<EventMention, String>> propertyGetters = new HashMap<String, Function<EventMention, String>>();
        for (String name : PROPERTY_NAMES) {
            propertyGetters.put(name, EvaluationOfClearTKEventProperties.getPropertyGetter(name));
        }
        HashMap<String, AnnotationStatistics<String>> statsMap = new HashMap<String, AnnotationStatistics<String>>();
        statsMap.put(DOC_TIME_REL, new AnnotationStatistics());
        JCasIterator casIter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (casIter.hasNext()) {
            JCas jCas = (JCas)casIter.next();
            JCas goldView = jCas.getView("GoldView");
            JCas systemView = jCas.getView("_InitialView");
            String text = goldView.getDocumentText();
            for (Segment segment : JCasUtil.select((JCas)jCas, Segment.class)) {
                if (THYMEData.SEGMENTS_TO_SKIP.contains(segment.getId())) continue;
                List<EventMention> goldEvents = EvaluationOfClearTKEventProperties.selectExact(goldView, EventMention.class, segment);
                List<EventMention> systemEvents = EvaluationOfClearTKEventProperties.selectExact(systemView, EventMention.class, segment);
                block3: for (String name : PROPERTY_NAMES) {
                    Function getProperty = (Function)propertyGetters.get(name);
                    ((AnnotationStatistics)statsMap.get(name)).add(goldEvents, systemEvents, eventMentionToSpan, getProperty);
                    for (int i = 0; i < goldEvents.size(); ++i) {
                        String goldOutcome = (String)getProperty.apply((Object)goldEvents.get(i));
                        if (i == systemEvents.size()) continue block3;
                        String systemOutcome = (String)getProperty.apply((Object)systemEvents.get(i));
                        if (goldOutcome.equals(systemOutcome)) continue;
                        EventMention event = goldEvents.get(i);
                        int begin = event.getBegin();
                        int end = event.getEnd();
                        int windowBegin = Math.max(0, begin - 50);
                        int windowEnd = Math.min(text.length(), end + 50);
                        this.loggers.get(name).fine(String.format("%s was %s but should be %s, in  ...%s[!%s!]%s...", name, systemOutcome, goldOutcome, text.substring(windowBegin, begin).replaceAll("[\r\n]", " "), text.substring(begin, end), text.substring(end, windowEnd).replaceAll("[\r\n]", " ")));
                    }
                }
            }
        }
        return statsMap;
    }

    public void logClassificationErrors(File outputDir, String outputFilePrefix) throws IOException {
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        for (String name : PROPERTY_NAMES) {
            Logger logger = this.loggers.get(name);
            logger.setLevel(Level.FINE);
            File outputFile = new File(outputDir, String.format("%s.%s.log", outputFilePrefix, name));
            FileHandler handler = new FileHandler(outputFile.getPath());
            handler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage() + '\n';
                }
            });
            logger.addHandler(handler);
        }
    }

    private static Function<EventMention, String> getPropertyGetter(final String propertyName) {
        return new Function<EventMention, String>(){

            public String apply(EventMention eventMention) {
                EventProperties eventProperties = eventMention.getEvent().getProperties();
                Feature feature = eventProperties.getType().getFeatureByBaseName(propertyName);
                return eventProperties.getFeatureValueAsString(feature);
            }
        };
    }

    @PipeBitInfo(name="Event Property Clearer", description="Clears all event properties.", role=PipeBitInfo.Role.SPECIAL)
    public static class ClearEventProperties
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (EventProperties eventProperties : JCasUtil.select((JCas)jCas, EventProperties.class)) {
                eventProperties.setAspect(null);
                eventProperties.setCategory(null);
                eventProperties.setContextualAspect(null);
                eventProperties.setContextualModality(null);
                eventProperties.setDegree(null);
                eventProperties.setDocTimeRel(null);
                eventProperties.setPermanence(null);
                eventProperties.setPolarity(0);
            }
        }
    }
}

