/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.data.analysis;

import com.google.common.collect.Lists;
import java.time.temporal.TemporalUnit;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import scala.collection.immutable.Set;

public class PrintNormalizedTemporalExpressions
extends JCasAnnotator_ImplBase {
    public static final String GOLD_VIEW_NAME = "GoldView";

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        JCas goldView;
        try {
            goldView = jCas.getView(GOLD_VIEW_NAME);
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        for (TimeMention mention : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, TimeMention.class))) {
            String timex = mention.getCoveredText().toLowerCase();
            Set<TemporalUnit> units = Utils.runTimexParser(timex);
            if (units == null) {
                System.out.println(timex + "|" + "n/a");
                continue;
            }
            for (TemporalUnit unit : units) {
                System.out.println(timex + "|" + unit.toString());
            }
        }
    }
}

